package com.tandbergtv.cms.portal.content.client.title.model.series;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleOverview;

public class UISeriesInfo implements IsSerializable, ICopyable{
	private Long seriesTitleId;   //ID of the associated Series title 
	private Long associatedSeriesDocId;
	private Long associatedSeasonAssetId;
	private String seriesFieldXpath;
	private String seasonFieldXpath;
	UITitleOverview titleOverView;
	
	Map <Long, List<UISeasonInfo>> seasonsLookUp = new LinkedHashMap<Long, List<UISeasonInfo>>(); //get the list of seasons from Series
	Map <String,Long> seriesAssetIdLookup = new HashMap<String,Long>();
	
	public Long getSeriesTitleId() {
		return seriesTitleId;
	}
	public void setSeriesTitleId(Long titleId) {
		this.seriesTitleId = titleId;
	}

	public Long getAssociatedSeriesDocId() {
		return associatedSeriesDocId;
	}
	public void setAssociatedSeriesDocId(Long associatedSeriesDocId) {
		this.associatedSeriesDocId = associatedSeriesDocId;
	}
	public Long getAssociatedSeasonAssetId() {
		return associatedSeasonAssetId;
	}
	public void setAssociatedSeasonAssetId(Long associatedSeasonAssetId) {
		this.associatedSeasonAssetId = associatedSeasonAssetId;
	}
	
	public String getSeriesFieldXpath() {
		return seriesFieldXpath;
	}
	public void setSeriesFieldXpath(String seriesFieldXpath) {
		this.seriesFieldXpath = seriesFieldXpath;
	}
	public String getSeasonFieldXpath() {
		return seasonFieldXpath;
	}
	public void setSeasonFieldXpath(String seasonFieldXpath) {
		this.seasonFieldXpath = seasonFieldXpath;
	}
	public Map<Long, List<UISeasonInfo>> getSeasonsLookUp() {
		return seasonsLookUp;
	}
	public void setSeasonsLookUp(Map<Long, List<UISeasonInfo>> seasonsLookUp) {
		this.seasonsLookUp = seasonsLookUp;
	}
	public Map<String, Long> getSeriesAssetIdLookup() {
		return seriesAssetIdLookup;
	}
	public void setSeriesAssetIdLookup(Map<String, Long> seriesAssetIdLookup) {
		this.seriesAssetIdLookup = seriesAssetIdLookup;
	}

	public UITitleOverview getTitleOverView() {
		return titleOverView;
	}
	public void setTitleOverView(UITitleOverview titleOverView) {
		this.titleOverView = titleOverView;
	}

	
	@Override
	public ICopyable createCopy() {
		UISeriesInfo  copy = new UISeriesInfo ();
	
		copy.setSeriesTitleId(this.getSeriesTitleId());
		copy.setSeriesFieldXpath(this.getSeriesFieldXpath()); 
		copy.setSeasonFieldXpath(this.getSeasonFieldXpath()); 
		copy.setAssociatedSeriesDocId(this.associatedSeriesDocId);
		copy.setAssociatedSeasonAssetId(this.associatedSeasonAssetId);
		
		Iterator<Long> iter = seasonsLookUp.keySet().iterator();
		while ( iter.hasNext() == true) {
			Long key = iter.next();
			List<UISeasonInfo> seasons = seasonsLookUp.get(key);
			copy.getSeasonsLookUp().put(key, seasons);
		}

		Iterator<String> seriter = seriesAssetIdLookup.keySet().iterator();
		while ( iter.hasNext() == true) {
			String key = seriter.next();
			Long assetId = seriesAssetIdLookup.get(key);
			copy.seriesAssetIdLookup.put(key, assetId);
		}
		
		UITitleOverview oc = this.getTitleOverView().createCopy();
		copy.setTitleOverView(oc);
		
		return copy;
	}
}
