package com.tandbergtv.cms.portal.content.client.title.model.sites;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;

public class UILocalTitleSites implements IsSerializable, ICopyable{
	/* Properties */
	UIDistributionSiteItem distributionSiteItem;
	List<UITrackingSiteItem> trackingSiteItems = new ArrayList<UITrackingSiteItem>();
	private Long localTitleId;
	private Long masterTitleId;

	@Override
	public UILocalTitleSites createCopy() {
		
		UILocalTitleSites copy = new UILocalTitleSites();
		
		copy.setLocalTitleId(this.getLocalTitleId());
		/* Create a copy of all the tracking site items */
		for (UITrackingSiteItem trackingSiteItem : this.getTrackingSiteItems()) {
			copy.getTrackingSiteItems().add(trackingSiteItem.createCopy());
		}	
						
		copy.setDistributionSiteItem(this.getDistributionSiteItem().createCopy());
		return copy;
	}

	public UIDistributionSiteItem getDistributionSiteItem() {
		return distributionSiteItem;
	}

	public void setDistributionSiteItem(UIDistributionSiteItem distributionSiteItem) {
		this.distributionSiteItem = distributionSiteItem;
	}

	public List<UITrackingSiteItem> getTrackingSiteItems() {
		return trackingSiteItems;
	}

	public void setTrackingSiteItems(List<UITrackingSiteItem> trackingSiteItems) {
		this.trackingSiteItems = trackingSiteItems;
	}

	public Long getLocalTitleId() {
		return localTitleId;
	}

	public void setLocalTitleId(Long localTitleId) {
		this.localTitleId = localTitleId;
	}

	public Long getMasterTitleId() {
		return masterTitleId;
	}

	public void setMasterTitleId(Long masterTitleId) {
		this.masterTitleId = masterTitleId;
	}
	
	public List<UITrackingSiteItem> getPagedTrackingSiteItems(int startIndexForPage, int pageSize) {
		List<UITrackingSiteItem> trackingSiteItemsForPage = new ArrayList<UITrackingSiteItem>();
		int i= startIndexForPage;
		int last = i+pageSize;
		while ( i<trackingSiteItems.size()&& i<last) {
			if (i >= 0)
				trackingSiteItemsForPage.add(trackingSiteItems.get(i));
			i++;
		}
		
        return trackingSiteItemsForPage;
	}

	public int getTotalTrackingSites() {
		return trackingSiteItems.size();
	}
	
}
