package com.tandbergtv.cms.portal.content.client.title.model.sites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;


public class UITitleSites implements IsSerializable, ICopyable{

	/* Properties */
	List<UIDistributionSiteItem> distributionSiteItems = new ArrayList<UIDistributionSiteItem>();
	Map <String, List<UITrackingSiteItem>> trackingSiteLookUp = new TreeMap<String, List<UITrackingSiteItem>>();
	List<UIActiveDistributionSiteItem> activeDistributionSiteItems = new ArrayList<UIActiveDistributionSiteItem>();
	private Long titleId=null;
	private UILocalTitleSites local=null; //data returned for local title
	//activeSiteNames and inactiveSiteNames are obtained from TargetResult after executing targetwithrules.
	private Set<String> activeSiteNames=new TreeSet<String>();
	private Set<String> inactiveSiteNames=new TreeSet<String>();
	
	public UILocalTitleSites getLocal() {
		return local;
	}

	public void setLocal(UILocalTitleSites local) {
		this.local = local;
	}
	
	public List<UIActiveDistributionSiteItem> getActiveDistributionSiteItems() {
		return activeDistributionSiteItems;
	}

	public void setActiveDistributionSiteItems(
			List<UIActiveDistributionSiteItem> activeDistributionSiteItems) {
		this.activeDistributionSiteItems = activeDistributionSiteItems;
	}
	
	public List<UIDistributionSiteItem> getDistributionSiteItems() {
		return distributionSiteItems;
	}
	
	public void setDistributionSiteItems(List<UIDistributionSiteItem> distSiteItems) {
		this.distributionSiteItems = (distSiteItems != null) ? distSiteItems
		        : new ArrayList<UIDistributionSiteItem>();		
	}
	
	public Long getTitleId() {
		return titleId;
	}

	public void setTitleId(Long masterTitleId) {
		this.titleId = masterTitleId;
	}

	public Set<String> getActiveSiteNames() {
		return activeSiteNames;
	}

	public void setActiveSiteNames(Set<String> activeSiteNames) {
		this.activeSiteNames = activeSiteNames;
	}

	public Set<String> getInactiveSiteNames() {
		return inactiveSiteNames;
	}

	public void setInactiveSiteNames(Set<String> inactiveSiteNames) {
		this.inactiveSiteNames = inactiveSiteNames;
	}

	@Override
	public UITitleSites createCopy() {
		
		UITitleSites copy = new UITitleSites();
		
		copy.setTitleId(this.getTitleId());
		/* Create a copy of all the distribution site items */
		for (UIDistributionSiteItem distSiteItem : this.getDistributionSiteItems()) {
			copy.getDistributionSiteItems().add(distSiteItem.createCopy());
		}	
						
		/* Create a copy of all the tracking site items */
		Iterator<String> iter = trackingSiteLookUp.keySet().iterator();
		while ( iter.hasNext() == true) {
			String key = iter.next();
			List<UITrackingSiteItem> val = trackingSiteLookUp.get(key);
			copy.getTrackingSiteLookUp().put(key, val);
		}

		for (String activeSiteName : activeSiteNames){
			copy.getActiveSiteNames().add(activeSiteName);
		}

		for (String inactiveSiteName : inactiveSiteNames){
			copy.getInactiveSiteNames().add(inactiveSiteName);
		}
		
		return copy;
	}
	
	public Map<String, List<UITrackingSiteItem>> getTrackingSiteLookUp() {
		return trackingSiteLookUp;
	}

	public void setTrackingSiteLookUp(
			Map<String, List<UITrackingSiteItem>> trackingSiteLookUp) {
		this.trackingSiteLookUp = trackingSiteLookUp;
	}

	/**
	 * @param distributionSite the name of the distribution site, null for all sites
	 * @param startIndexForPage the starting index in the list of tracking sites for this distribution site
	 * @param pageSize the maximum number of tracking sites to return
	 * @return the list of tracking sites for the distribution site in the page as specified
	 */		
	public List<UITrackingSiteItem> getPagedTrackingSiteItems(String distributionSite, int startIndexForPage, int pageSize) {
		List<UITrackingSiteItem> trackingSiteItemsForPage = new ArrayList<UITrackingSiteItem>();
		List<UITrackingSiteItem> items = null;
		if (distributionSite == null && trackingSiteLookUp.values() != null) {
			Collection<List<UITrackingSiteItem>>allItems = trackingSiteLookUp.values();
			Iterator<List<UITrackingSiteItem>> iter = allItems.iterator();
			items = new ArrayList<UITrackingSiteItem>();
			while(iter.hasNext()){
				items.addAll(iter.next());
			}
		}
		else
            items = trackingSiteLookUp.get(distributionSite);
		if (items != null) {
			int i= startIndexForPage;
			int last = i+pageSize;
			while ( i<items.size()&& i<last) {
				if (i >= 0)
					trackingSiteItemsForPage.add(items.get(i));
				i++;
			}
		}
		
        return trackingSiteItemsForPage;
	}

	
	/**
	 * @param distributionSite the name of the distribution site, null for all sites
	 * @return the number of tracking sites for the specified distribution site
	 */	
	public int getTotalTrackingSites(String distributionSite) {
		int count=0;
		if (distributionSite == null && trackingSiteLookUp.values() != null) {
			Collection<List<UITrackingSiteItem>>allItems = trackingSiteLookUp.values();
			Iterator<List<UITrackingSiteItem>> iter = allItems.iterator();
			while(iter.hasNext()){
				count += iter.next().size();
			}
		}
		else {
			List<UITrackingSiteItem> items = trackingSiteLookUp.get(distributionSite);
			if (items != null)
				count = items.size();
		}
		
		return count;
	}

}
