package com.tandbergtv.cms.portal.content.client.title.service;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.title.model.NameValuePair;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewInitData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewResponse;
import com.tandbergtv.cms.portal.content.client.title.model.rules.TitleSavePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIMsoOverrideResult;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIMsoRuleSet;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIRuleActionChange;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UiMso;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;


@RemoteServiceRelativePath("service/content/title/IRulesPreviewService")
public interface IRulesPreviewService extends RemoteService 
{
	public String RELATIVE_PATH = "service/content/title/IRulesPreviewService";
	
	public List<NameValuePair> getSites() throws NeptuneException;
	public List<NameValuePair> getRulesBySiteId(Integer siteId) throws NeptuneException;
	public List<NameValuePair> getGlobalRules() throws NeptuneException;
	public RulePreviewInitData getInitData(long titleId) throws NeptuneException;
	
	public RulePreviewResponse previewRule(RulePreviewRequest request) throws NeptuneException;
	public RulePreviewResponse previewRuleSpec(RulePreviewRequest request, boolean useHtml) throws NeptuneException;

	public RulePreviewResponse previewRule(TitleSavePreviewRequest request) throws NeptuneException;
	public RulePreviewResponse previewRuleSpec(TitleSavePreviewRequest request, boolean useHtml) throws NeptuneException;
	public List<UIMsoRuleSet> getAllShallowMsoRuleSets() throws NeptuneException;
	public List<UIRuleActionChange> getMsoRuleSet(Long siteTitleId, Integer ruleSetId, Integer msoId) throws NeptuneException;
	public List<UIRuleActionChange> getAllMSORuleSets(Long siteTitleId, Integer msoId) throws NeptuneException;
	public List<UiMso> getMsos(Long siteTitleId, Integer ruleSetId) throws NeptuneException;
	public Boolean isMediaPathSiteTitle(Integer titleId) throws NeptuneException;
}
