package com.tandbergtv.cms.portal.content.client.title.service;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.title.model.NameValuePair;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewInitData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewResponse;
import com.tandbergtv.cms.portal.content.client.title.model.rules.TitleSavePreviewRequest;

import com.tandbergtv.cms.portal.content.client.title.model.rules.UIMsoRuleSet;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIRuleActionChange;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UiMso;





public interface IRulesPreviewServiceAsync 
{
	public void getSites(AsyncCallback<List<NameValuePair>> callback);
	public void getRulesBySiteId(Integer siteId, AsyncCallback<List<NameValuePair>> callback);
	public void getGlobalRules(AsyncCallback<List<NameValuePair>> callback);
	public void getInitData(long titleId, AsyncCallback<RulePreviewInitData> callback);
	
	public void previewRule(RulePreviewRequest request, AsyncCallback<RulePreviewResponse> callback);
	public void previewRuleSpec(RulePreviewRequest request, boolean useHtml, AsyncCallback<RulePreviewResponse> callback);

	public void previewRule(TitleSavePreviewRequest request, AsyncCallback<RulePreviewResponse> callback);
	public void previewRuleSpec(TitleSavePreviewRequest request, boolean useHtml, AsyncCallback<RulePreviewResponse> callback);
	public void getAllShallowMsoRuleSets(AsyncCallback<List<UIMsoRuleSet>> neptuneAsyncCallback);
	public void getMsoRuleSet(Long siteTitleId, Integer ruleSetId,Integer msoId, AsyncCallback<List<UIRuleActionChange>> neptuneAsyncCallback);
	public void getAllMSORuleSets(Long siteTitleId, Integer msoId, AsyncCallback<List<UIRuleActionChange>> neptuneAsyncCallback);
	public void getMsos(Long siteTitleId, Integer ruleSetId, AsyncCallback<List<UiMso>> callback);
	public void isMediaPathSiteTitle(Integer siteId, AsyncCallback<Boolean> callback) ;
}

