package com.tandbergtv.cms.portal.content.client.title.service;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeriesInfo;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/content/title/ISeriesTitleService")
public interface ISeriesTitleService  extends RemoteService  {


	/**
	 * Get column Infos for displaying episodes table.
	 * 
	 * @return list of columns
	 */
	public List<UiColumn> getEpisodeSearchColumns() throws NeptuneException;
	
	/**
	 * Search for episode titles that are assigned to given series and season.
	 * 
	 * @param seriesDocumentId
	 * @param seasonAssetId
	 * @return episode titles with the metadata fields that are specified in the configuration file. 
	 */
	public UISearchResult getEpisodeTitles(Long seriesDocumentId, Long seasonAssetId) throws NeptuneException;

	/**
	 * @param titleId     the episode titleId
	 * Get associated Series/Season and also all available Series infos, with series and season id fields.
	 *
	 */
	public UISeriesInfo getSeriesTitleInfos(Long titleId) throws NeptuneException;
	
	/**
	 * Associate title (episode) to Series/Season
	 * @param titleId     the episode titleId
	 * @param seriesDocumentId
	 * @param seasonAssetId
	 * @return UISeriesInfo. 
	 *
	 */
	public UISeriesInfo associateTitleToSeries(Long titleID, Long seriesDocumentId, Long seasonAssetId) throws NeptuneException;	

	/**
	 * Disassociate title (episode) from Series/Season
	 * @param titleId   the episode title Id
	 * @param seriesDocumentId  
	 * @return UISeriesInfo. 
	 *
	 */
	public UISeriesInfo disassociateTitleFromSeries(Long titleID) throws NeptuneException;	
}
