package com.tandbergtv.cms.portal.content.client.title.service;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;


/**
 * Service interface defining methods used by the Title Sites View
 * 
 * @author bng
 */
@RemoteServiceRelativePath("service/content/title/ITitleSitesService")
public interface ITitleSitesService extends RemoteService {

	/**
	 * Distribute a list of titles to selected active sites
	 * 
	 * @param localTitleId The local title ID
	 * @return TargetSitesResponse results of the operation
	 */
	public TargetSitesResponse distributeImmediately(long localTitleId) throws NeptuneException;

	/**
	 * Get the Title sites for a title given the Title ID
	 * 
	 * @param titleId The title ID (can be master or local title)
	 * @return The Title sites
	 */
	public UITitle getTitleSites(Long titleId) throws NeptuneException;
	
	/**
	 * Target a title to sites using rules given the master Title ID
	 * 
	 * @param masterTitleId The title ID
	 * @return The Title sites
	 */
	public UITitle targetWithRules(Long masterTitleId) throws NeptuneException;

	/**
	 * Target a master title to list of active sites
	 * 
	 * @param masterTitleId The title ID
	 * @param siteIds the list of site ids to target to
	 * @return The Title sites
	 */
	public UITitle target(Long masterTitleId, List<Integer> siteIds) throws NeptuneException;
	
	/**
	 * Return list of active distribution site names
	 * 
	 * @return The list of active site names
	 */
	public List<String> getActiveDistributionSiteNames() throws NeptuneException;
	
	/**
	 * Target a list of titles to selected active sites
	 * 
	 * @param titleIds The list of title IDs
	 * @param activeSiteNames the selected sites to target to
	 * @return TargetSitesResponse results of the operation
	 */
	public TargetSitesResponse target(List<Long> titleIds, List<String> activeSiteNames) throws NeptuneException;
	
}
