package com.tandbergtv.cms.portal.content.client.title.service;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;

/**
 * Service interface defining methods used by the Title Sites View
 * 
 * @author bng
 * @generated generated asynchronous callback interface to be used on the client side
 */

public interface ITitleSitesServiceAsync {
	/**
	 * Distribute a list of titles to selected active sites
	 * 
	 * @param localTitleId local title ID
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The TargetSitesResponse
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void distributeImmediately(long localTitleId, AsyncCallback<TargetSitesResponse> callback);

	/**
	 * Get the Title sites for a title (can be master or local) given the Title ID
	 * 
	 * @param titleId The title ID
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The Title sites
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getTitleSites(Long titleId, AsyncCallback<UITitle> callback);

	/**
	 * Target a title to sites using rules
	 * 
	 * @param masterTitleId The title ID
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The Title sites
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void targetWithRules(Long masterTitleId, AsyncCallback<UITitle> callback);

	/**
	 * Target a title to selected sites 
	 * 
	 * @param masterTitleId The title ID
	 * @param siteIds the list of site ids to target to
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The Title sites
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void target(Long masterTitleId, List<Integer> siteIds, AsyncCallback<UITitle> callback);
	
	/**
	 * Get the list of active distribution site names
	 * 
	 * @gwt.callbackReturn The site names
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getActiveDistributionSiteNames(AsyncCallback<List<String>> callback);

	/**
	 * Target a list of titles to selected sites 
	 * 
	 * @param titleIds The list of title IDs
	 * @param activeSiteNames the list of selected sites
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The TargetSitesResponse
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void target(List<Long> titleIds, List<String> activeSiteNames, AsyncCallback<TargetSitesResponse> callback);
}
