/*
 * Created on Apr 27, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */
package com.tandbergtv.cms.portal.content.client.title.service;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.title.model.UIActionTitle;
import com.tandbergtv.cms.portal.content.client.title.model.UIMetadataEnhInfo;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.UIViewInfo;
import com.tandbergtv.cms.portal.content.client.title.model.compare.TitleCompareRequest;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.UITitleInfo;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Service interface defining methods used by the Title View
 * 
 * @author Vijay Silva
 * @generated generated asynchronous callback interface to be used on the client side
 */
public interface ITitleViewServiceAsync {

	/**
	 * Create a new Title saving the title metadata
	 * 
	 * @param title The title to create
	 * @param callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void createTitle(UITitle title, String meRequestKey, AsyncCallback<UITitle> callback);

	/**
	 * Create a new Title in 'Draft' status saving the title metadata
	 * 
	 * @param title The title to create
	 * @param callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void createTitleAsDraft(UITitle title, AsyncCallback<UITitle> callback);

	/**
	 * Update the title metadata given the root asset for the title and the title ID
	 * 
	 * @param titleId The title ID
	 * @param asset The root asset for the title
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The updated title
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void updateTitleMetadata(UITitle title, Long requestKey, String action, String listOfAssetIds, String meRequestKey,
          AsyncCallback<UITitle> callback);

	/**
	 * Update the title metadata given the root asset for the title and the title ID
	 * 
	 * @param titleId The title ID
	 * @param asset The root asset for the title
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The updated title
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void updateTitleMetadataAsDraft(UITitle title, AsyncCallback<UITitle> callback);

	/**
	 * Update the title metadata given the root asset for the title and the title ID
	 * 
	 * @param titleId The title ID
	 * @param asset The root asset for the title
	 * @return The updated title
	 */
	void batchUpdateTitleMetadata(UITitle updates, List<Long> titleIds,
			boolean draft, boolean currentState, AsyncCallback<Void> callback);

	/**
	 * Get the Title Metadata for the given title ID
	 * 
	 * @param titleId The title ID
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The title metadata
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getTitle(Long titleId, AsyncCallback<UITitle> callback);

	/**
	 * Get the Title History for a title given the Title ID
	 * 
	 * @param titleId The title ID
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The Title History
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getTitleHistory(Long titleId, AsyncCallback<UITitle> callback);

	/**
	 * Get the title metadata for a specific revision of the title
	 * 
	 * @param titleId The title ID
	 * @param titleRevision The title revision
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @gwt.callbackReturn The root asset for the title of that revision
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getTitleRevisionInfo(Long titleId, String titleRevision, AsyncCallback<UITitleInfo> callback);

	/**
	 * Roll back the title to the specific revision
	 * 
	 * @param titleId The title ID
	 * @param titleRevision The title revision
	 * @param callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void rollbackTitle(Long titleId, String titleRevision, AsyncCallback<Void> callback);

	/**
	 * Roll back the title to the specific revision without performing any validation checks. Also
	 * sets the title status to DRAFT.
	 * 
	 * @param titleId The title ID
	 * @param titleRevision The title revision
	 * @param callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void rollbackTitleAsDraft(Long titleId, String titleRevision, AsyncCallback<Void> callback);

	/**
	 * Builds a list of the File Paths that can be used as values for the File URI widget
	 * 
	 * @gwt.callbackReturn The list of file paths
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getAvailableFilePaths(AsyncCallback<List<UIAssetFilePath>> callback);

	/**
	 * Sends a message to workflow to complete a manual task of selecting a title and asset
	 * 
	 * @param titleId Selected title
	 * @param assetId Selected asset
	 * @param requestKey Request key for the message
	 * @param callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void sendSelectAssetNotification(Long titleId, Long assetId, Long requestKey,
	        AsyncCallback<Void> callback);

	/**
	 * Sends a message to workflow to complete a manual task of validating a title
	 * 
	 * @param requestKey Request key for the message
	 * @param callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void sendValidationSuccessConfirmation(Long requestKey, AsyncCallback<Void> callback);

	
	/**
	 * Sends a message to workflow to complete a manual task of resolving a conflict from metadata enhancment search results.
	 * 
	 * @param requestKey Request key for the message
	 * @param callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void sendMEDeconflictSuccessConfirmation(Long requestKey, AsyncCallback<Void> callback);
	
	/**
	 * Asynchronous method call for ITitleViewService method
	 * 
	 * @see ITitleViewService#previewTitle(UIActionTitle, String)
	 */
	void previewTitle(UIActionTitle title, String specification, boolean useHtml, AsyncCallback<String> callback);

	/**
	 * Asynchronous method call for ITitleViewService method
	 * 
	 * @see ITitleViewService#compareTitles(TitleCompareRequest request)
	 */
	void compareTitles(TitleCompareRequest request,
	        AsyncCallback<UITitleCompareData> callback);

	/**
	 * Asynchronous method call for ITitleViewService method
	 * 
	 * @see ITitleViewService#compareTitlePreviews(UIActionTitle, UIActionTitle, String)
	 */
	void compareTitlePreviews(UIActionTitle uiTitle1, UIActionTitle uiTitle2,
	        String specificationName, boolean useHtml, AsyncCallback<UITitleCompareXmlData> callback);
	
	/**
	 * Asynchronous method call for ITitleViewService method
	 * 
	 * @see ITitleViewService#hasViewPermission(Long)
	 */
	void hasViewPermission( Long titleId, AsyncCallback<Boolean> callback );
	
	
	/**
	 * Asynchronous method call for ITitleViewService method
	 * 
	 * @see ITitleViewService#getViewInfo(Long)
	 */
	void getViewInfo( Long titleId,  AsyncCallback<UIViewInfo> callback);
	
	/**
	 * Asynchronous version of ITitleViewService method
	 * @see ITitleViewService#getTitleMetadataInfo(Long, Long)
	 * 
	 * @param titleId
	 * @param contentClassId
	 * @param partnerId
	 * @param callback
	 */
	public void getTitleMetadataInfo(Long titleId, Long contentClassId, Long partnerId, AsyncCallback<UITitleInfo> callback);
	
	/**
	 * Async version of {@link ITitleViewService#isMediaPathSiteTitle(Long)}.
	 * 
	 * @param titleId
	 * @param callback
	 */
	public void isMediaPathSiteTitle(Long titleId, AsyncCallback<Boolean> callback);

	public void getTitleMetadataInfoForBatch( Long contentClassId,
			AsyncCallback<UITitleInfo> neptuneAsyncCallback);
	
	/**
	 * Search for metadata enhancements from 3rd party data sources.
	 * 
	 * @param title The title to create or update
	 * @param callback the callback that will be called to receive the return values.
	 */
	public void searchMetadataEnhancement(UITitle title, AsyncCallback<UIMetadataEnhInfo> callback);
	
	/**
	 * Delete Metadata Enhancement cache.
	 * 
	 * @param Metadata Enhancement request key
	 * @throws NeptuneException
	 */
	public void cleanUpMetadataEnhancementRequest(String meRequestKey, AsyncCallback<Void> callback);
}
