/*
 * Created on Jul 14, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.service;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Exception indicating failure when performing an action on the title on the server
 * 
 * @author Vijay Silva
 */
public class TitleServiceException extends NeptuneException {

	/* Serialization UID */
	private static final long serialVersionUID = 3634653048474094023L;
	private boolean localizedMessage = false;

	/**
	 * Constructor
	 */
	public TitleServiceException() {
	}

	/**
	 * Constructor
	 * 
	 * @param message The detail message
	 */
	public TitleServiceException(String message) {
		this(message, false);
	}

	/**
	 * Constructor
	 * 
	 * @param message The detail message
	 * @param localizedMessage Flag indicating that the message is localized
	 */
	public TitleServiceException(String message, boolean localizedMessage) {
		super(message);
		this.localizedMessage = localizedMessage;
	}

	/**
	 * @return the localizedMessage
	 */
	public boolean isLocalizedMessage() {
		return localizedMessage;
	}
}
