/*
 * Created on Jul 14, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.service;

import java.util.List;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Exception handled by the client indicating that the title validation failed during persistence.
 * 
 * @author Vijay Silva
 */
public class TitleValidationUIException extends NeptuneException {

	/* Serialization UID */
	private static final long serialVersionUID = 4304439955767232626L;

	/* Properties */
	private List<UITitleValidationMessage> messages;
	private boolean fatal = false;

	/**
	 * No argument constructor for serialization
	 */
	public TitleValidationUIException() {
	}

	/**
	 * Constructor
	 * 
	 * @param messages The list of validation messages
	 */
	public TitleValidationUIException(List<UITitleValidationMessage> messages) {
		this.messages = messages;
	}

	/**
	 * Constructor
	 * 
	 * @param messages The list of validation messages
	 * @param message The detail message
	 */
	public TitleValidationUIException(List<UITitleValidationMessage> messages, String message) {
		super(message);
		this.messages = messages;
	}

	/**
	 * Constructor
	 * 
	 * @param messages The list of validation messages
	 * @param isFatal Indicates that this error cannot be fixed directly by the user
	 * @param message The detail message
	 */
	public TitleValidationUIException(List<UITitleValidationMessage> messages, boolean isFatal,
	        String message) {
		super(message);
		this.fatal = isFatal;
		this.messages = messages;
	}

	/**
	 * @return the messages The validation messages
	 */
	public List<UITitleValidationMessage> getValidationMessages() {
		return messages;
	}

	/**
	 * Determine if this exception can be fixed by the user by directly modifying the title.
	 * 
	 * @return true if the user cannot recover directly, false otherwise
	 */
	public boolean isFatal() {
		return this.fatal;
	}
}
