/*
 * Created on Feb 25, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.service.asset;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;

/**
 * Factory interface that defines the create methods required to build a UI asset and field model
 * objects based on an asset specification.
 * 
 * @author Vijay Silva
 */
public interface IUIAssetFactory {

	/**
	 * Create a root asset using the specification to determine the child assets to include for the
	 * asset. If there are several root asset types available, any of the available types can be
	 * used as the root asset.
	 * 
	 * @param specification The specification
	 * @return The asset built for the specification
	 */
	public UIAsset createAsset(UIAssetSpecification specification, boolean batchEdit);

	/**
	 * Create a root asset using the specification and the root asset type (cannot be null). Allows
	 * creation of root assets for specifications that support more than one root asset definition.
	 * Creates an asset for the specification using the root asset definition with matching asset
	 * type.
	 * 
	 * @param specification The specification
	 * @param rootAssetType The asset type to use for the root asset
	 * @return The asset built for the specification using the asset type
	 * @throws RuntimeException thrown if the asset type is null or if the specification does not
	 *         contain a root asset definition with matching asset type
	 */
	public UIAsset createAsset(UIAssetSpecification specification, String rootAssetType, boolean batchEdit);

	/**
	 * Creates an asset based on the asset definition provided
	 * 
	 * @param assetDefinition The asset definition
	 * @return The asset built for the asset definition
	 */
	public UIAsset createAsset(UIAssetDefinition assetDefinition);

	/**
	 * Creates an asset based on the asset definition provided, and optionally build the required
	 * child assets based on the flag provided.
	 * 
	 * @param assetDefinition The asset definition
	 * @param buildChildren Flag indicating if the required children should be built.
	 * @return The asset built for the asset definition
	 */
	public UIAsset createAsset(UIAssetDefinition assetDefinition, boolean buildChildren, boolean batchEdit);

	/**
	 * Creates a field for an asset. Does not build the required child fields based on the field
	 * definition provided.
	 * 
	 * @param fieldDefinition The field definition
	 * @return The field
	 */
	public UIField createAssetField(UIFieldDefinition fieldDefinition);

	/**
	 * Creates a field for an asset and optionally build the child fields based on the flag
	 * provided.
	 * 
	 * @param fieldDefinition The field definition
	 * @param buildChildren Flag indicating that the child fields need to be built
	 * @return The field
	 */
	public UIField createAssetField(UIFieldDefinition fieldDefinition, boolean buildChildren);

	/**
	 * Create an asset file given the asset file definition
	 * 
	 * @param fileDefinition The asset file definition
	 * @return The asset file
	 */
	public UIAssetFile createAssetFile(UIAssetFileDefinition fileDefinition);

	/**
	 * Create an asset file field given the asset file definition
	 * 
	 * @param fieldDefinition The asset file field definition
	 * @return The asset file field
	 */
	public UIAssetFileField createAssetFileField(UIAssetFileFieldDefinition fieldDefinition);
}
