/*
 * Created on Feb 25, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.service.asset;

import java.util.List;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;

/**
 * Factory to create new UI asset model objects
 * 
 * @author Vijay Silva
 */
public class UIAssetFactory implements IUIAssetFactory {

	/**
	 * Constructor
	 */
	public UIAssetFactory() {
	}

	/**
	 * {@inheritDoc}
	 */
	public UIAsset createAsset(UIAssetSpecification specification, boolean batchEdit) {
		return this.create(specification, null, batchEdit);
	}

	/**
	 * {@inheritDoc}
	 */
	public UIAsset createAsset(UIAssetSpecification specification, String rootAssetType, boolean batchEdit) {
		if (rootAssetType == null) {
			throw new RuntimeException("The root asset type cannot be null.");
		}

		return this.create(specification, rootAssetType, batchEdit);
	}

	/**
	 * {@inheritDoc}
	 */
	public UIAsset createAsset(UIAssetDefinition assetDefinition) {
		return this.createAsset(assetDefinition, false, false);
	}

	/**
	 * {@inheritDoc}
	 */
	public UIAsset createAsset(UIAssetDefinition assetDefinition, boolean buildChildren, boolean batchEdit) {
		UIAssetBuilder builder = new UIAssetBuilder();
		return builder.build(assetDefinition, buildChildren, batchEdit);
	}

	/**
	 * {@inheritDoc}
	 */
	public UIField createAssetField(UIFieldDefinition fieldDefinition) {
		return this.createAssetField(fieldDefinition, false);
	}

	/**
	 * {@inheritDoc}
	 */
	public UIField createAssetField(UIFieldDefinition fieldDefinition, boolean buildChildren) {
		UIFieldBuilder builder = new UIFieldBuilder();
		return builder.build(fieldDefinition, buildChildren);
	}

	/**
	 * {@inheritDoc}
	 */
	public UIAssetFile createAssetFile(UIAssetFileDefinition fileDefinition) {
		UIAssetFileBuilder builder = new UIAssetFileBuilder();
		return builder.build(fileDefinition);
	}

	/**
	 * {@inheritDoc}
	 */
	public UIAssetFileField createAssetFileField(UIAssetFileFieldDefinition fieldDefinition) {
		UIAssetFileBuilder builder = new UIAssetFileBuilder();
		return builder.build(fieldDefinition);
	}

	/*
	 * Creates an asset object with matching asset type (or any asset type if asset type is null)
	 * using the input specification
	 */
	private UIAsset create(UIAssetSpecification specification, String assetType, boolean batchEdit) {
		/* Get all root definitions and find matching definition by asset type */
		UIAssetDefinition matchingRoot = null;
		List<UIAssetDefinition> definitions = specification.getAssetDefinitions();
		for (UIAssetDefinition definition : definitions) {
			if (assetType == null || assetType.equals(definition.getAssetType())) {
				matchingRoot = definition;
				break;
			}
		}

		/* Verify that a root asset definition was found */
		if (matchingRoot == null) {
			String msg = "Failed to find a root asset definition for the provided specification.";
			throw new RuntimeException(msg);
		}

		/* Build the asset using the root found */
		return this.createAsset(matchingRoot, true, batchEdit);
	}
}
