/*
 * Created on Mar 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.service.asset;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;

/**
 * @author Vijay Silva
 */
class UIAssetFileBuilder {

	/**
	 * Default Constructor
	 */
	public UIAssetFileBuilder() {
	}

	/**
	 * Builds an asset file based on the definition provided.
	 * 
	 * @param fileDefinition The asset file definition
	 * @return The asset file
	 */
	public UIAssetFile build(UIAssetFileDefinition fileDefinition) {
		return this.buildFile(fileDefinition);
	}

	/**
	 * Builds an asset file field based on the definition provided.
	 * 
	 * @param fieldDefinition The asset file field definition
	 * @return The asset file field
	 */
	public UIAssetFileField build(UIAssetFileFieldDefinition fieldDefinition) {
		return this.buildField(fieldDefinition);
	}

	/*
	 * Build the asset file
	 */
	private UIAssetFile buildFile(UIAssetFileDefinition definition) {
		UIAssetFile file = new UIAssetFile();

		/* Does not build the fields for the asset file */
		return file;
	}

	/*
	 * Build the asset file field
	 */
	private UIAssetFileField buildField(UIAssetFileFieldDefinition definition) {
		UIAssetFileField fileField = new UIAssetFileField();
		UIFieldBuilder fieldBuilder = new UIFieldBuilder();
		UISimpleField<?> field = (UISimpleField<?>) fieldBuilder.build(definition.getFieldDefinition());
		fileField.setField(field);

		return fileField;
	}
}
