/*
 * Created on Feb 25, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.service.asset;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIBooleanField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIDateField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIFloatField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIIntegerField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIFieldDefinitionVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;

/**
 * Service implementation for the field builder that constructs a field and its required children
 * based on the provided field definition.
 * 
 * @author Vijay Silva
 */
class UIFieldBuilder implements IUIFieldDefinitionVisitor {

	/* The field built after this visitor is successfully accepted */
	private transient UIField builtField = null;

	/* Flag indicating if the required children need to be built */
	private transient boolean buildRequiredChildren = true;

	/**
	 * Constructor
	 */
	public UIFieldBuilder() {
	}

	/**
	 * Builds a field and its required child fields based on the field definition provided.
	 * 
	 * @param fieldDefinition The field definition
	 * @return The field
	 */
	public UIField build(UIFieldDefinition fieldDefinition) {
		return this.build(fieldDefinition, true);
	}

	/**
	 * Builds a field based on the field definition provided. Optionally recursively builds the
	 * child field tree if the flag is set to true.
	 * 
	 * @param fieldDefinition The field definition
	 * @param buildChildren Flag to build the field tree of children
	 * @return The field
	 */
	public UIField build(UIFieldDefinition fieldDefinition, boolean buildChildren) {
		this.buildRequiredChildren = buildChildren;
		fieldDefinition.accept(this);
		return this.getBuiltField();
	}

	/**
	 * Build the field based on the complex field definition.
	 * 
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIFieldDefinitionVisitor#visit
	 *      (com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition)
	 */
	public void visit(UIComplexFieldDefinition fieldDefinition) {
		UIComplexField field = new UIComplexField();
		field.setName(fieldDefinition.getName());
		if (this.buildRequiredChildren) {
			for (UIFieldDefinition childDefinition : fieldDefinition.getChildren()) {
				int requiredCount = childDefinition.getMinimumCount();
				for (int i = 0; i < requiredCount; i++) {
					UIField childField = this.build(childDefinition);
					field.addField(childField);
				}
			}
		}

		this.builtField = field;
	}

	@Override
	public void visit(UIBooleanFieldDefinition fieldDefinition) {
		UIBooleanField field = new UIBooleanField();
		buildSimpleField(field, fieldDefinition);
	}

	@Override
	public void visit(UIIntegerFieldDefinition fieldDefinition) {
		UIIntegerField field = new UIIntegerField();
		buildSimpleField(field, fieldDefinition);
	}

	@Override
	public void visit(UIFloatFieldDefinition fieldDefinition) {
		UIFloatField field = new UIFloatField();
		buildSimpleField(field, fieldDefinition);
	}

	@Override
	public void visit(UIDateFieldDefinition fieldDefinition) {
		UIDateField field = new UIDateField();
		buildSimpleField(field, fieldDefinition);
	}

	@Override
	public void visit(UITimeFieldDefinition fieldDefinition) {
		UITimeField field = new UITimeField();
		buildSimpleField(field, fieldDefinition);
	}

	@Override
	public void visit(UIStringFieldDefinition fieldDefinition) {
		UIStringField field = new UIStringField();
		buildSimpleField(field, fieldDefinition);
	}

	/*
	 * Copy the simple field properties and set the built field
	 */
	private void buildSimpleField(UISimpleField<?> field, UISimpleFieldDefinition fieldDefinition) {
		field.setName(fieldDefinition.getName());
		field.setAttribute(fieldDefinition.isAttribute());

		this.builtField = field;
	}

	/*
	 * Get the built field and reset the state maintained
	 */
	private UIField getBuiltField() {
		UIField field = this.builtField;
		this.builtField = null;
		this.buildRequiredChildren = true;
		return field;
	}
}
