package com.tandbergtv.cms.portal.content.client.title.view;

import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.create.model.ContentCreateData;
import com.tandbergtv.cms.portal.content.client.create.model.TitleViewData;
import com.tandbergtv.cms.portal.content.client.create.service.IContentCreateViewService;
import com.tandbergtv.cms.portal.content.client.create.service.IContentCreateViewServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;

/**
 * Handles communication with the server via RPC and updates views
 * @author eyevkar
 */
public class ContentCreateController {
	// PRC Services
	private IContentCreateViewServiceAsync service = GWT.create(IContentCreateViewService.class);
	// Main view
	private ContentCreateView view;
	
	/**
	 * Constructor
	 * @param view
	 */
	public ContentCreateController(ContentCreateView view) {
		this.view = view;
	}
	
	public void showSelectorView(String anchor) 
	{
		view.showEmptyView();
		view.showBusyIndicator();

		// Parse anchor an get parameters
		AnchorTokenizer tkz = new AnchorTokenizer();
		Map<String, String> map = tkz.parseAnchor(anchor);
		final String type = map.get("type");
		final String returnAnchor = map.get("returnAnchor");
		
		if("category".equals(type))
		{
			service.getCategoryContentCreateData(new NeptuneAsyncCallback<ContentCreateData>() 
			{
				@Override
				public void onNeptuneFailure(Throwable caught) 
				{
					view.showError(caught.getMessage());
					view.hideBusyindicator();
				}
				
				@Override
				public void onNeptuneSuccess(ContentCreateData data) 
				{
					view.showSelectorViewForCategory(data, returnAnchor);
					view.hideBusyindicator();
				}
			});
		}
		else
		{
			service.getContentCreateData(new NeptuneAsyncCallback<ContentCreateData>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
					view.showError(caught.getMessage());
					view.hideBusyindicator();
				}
				
				@Override
				public void onNeptuneSuccess(ContentCreateData data) {
					view.showSelectorView(data, returnAnchor);
					view.hideBusyindicator();
				}
			});
		}
	}
	
	public void showTitleView(TitleViewData tvData, String returnAnchor) 
	{
		view.showBusyIndicator();
		view.showTitleView(tvData, returnAnchor);
		view.hideBusyindicator();
	}
}
