package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.tandbergtv.cms.portal.content.client.Anchors;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.create.model.ContentCreateData;
import com.tandbergtv.cms.portal.content.client.create.model.TitleViewData;
import com.tandbergtv.cms.portal.content.client.create.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesTitleView;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;

/**
 * Main view to create a new title. 
 * This view is implemented as a wizard with two steps:
 *     Step 1: Select a source provider and a content class
 *     Step 2: Edit title metadata    
 * @author eyevkar
 */
public class ContentCreateView extends Composite 
{
	private ContentCreateController controller;
	
	private final SimpleContainer rootContainer;
	// Empty panel. Show during RPC call.
	private SimplePanel emptyPanel;
	// Step 1 of the wizard. Selects a source provider and a content class 
	private ContentSelectorView selectorView;
	// Step 2 of the wizard. Edit metadata
	private TitleView titleView;

	// Busy indicator.
	private BusyIndicator busyIndicator;
	
	/**
	 * Constructor
	 */
	public ContentCreateView() {
		rootContainer = new SimpleContainer();
		this.initWidget(rootContainer);
		busyIndicator = new BusyIndicator();
	}
	
	/**
	 * Shows title metadata view. (Step 2 of the wizard)
	 */
	public void showTitleView(TitleViewData data, String returnAnchor) 
	{
		createTitleView(data.contentClassTypeId);

		if(returnAnchor == null || returnAnchor.trim().length() < 1) 
		{
			returnAnchor = Anchors.CONTENT_SEARCH_ANCHOR;
		}
		
		titleView.addViewCancelHandler(new TitleViewCancelHandler(returnAnchor));
		
		NeptuneApplication application = NeptuneApplication.getApplication();
		ContentComponent component = application.getComponent(ContentComponent.class);
		long partnerId = data.partnerId;
		long contentClassId = data.contentClassId;
		
		TitleViewInput viewInput = new TitleViewInput(partnerId, contentClassId);
		titleView.setInput(viewInput);
		titleView.refresh();
		
		rootContainer.setWidget(titleView);
	}
	

	private void createTitleView(int contentClassType) 
	{
		if(contentClassType == UIContentClass.TYPE_SERIES)
			titleView = new SeriesTitleView();
		else
			titleView = new TitleView();
		
		titleView.addViewAnchorChangeHandler(new ViewAnchorChangeHandler() 
		{
			@Override
			public void onAnchorChange(ViewAnchorChangeEvent event) 
			{
				/* Check if the view is for a saved title, change the anchor */
				if(titleView.getInput() != null && titleView.getInput().isExistingTitle()) 
				{
					String anchor = Anchors.CONTENT_SEARCH_ANCHOR;
					if(event.getAnchor() != null && event.getAnchor().trim().length() > 0) 
					{
						anchor += "." + event.getAnchor();
					}
					History.newItem(anchor, false);
				} 
				else 
				{
					//delegateViewAnchorChangeEvent(event);
				}
			}
		});
	}
	
	/**
	 * Shows selector view. (Step 1 of the wizard)
	 */
	public void showSelectorView(ContentCreateData data, String returnAnchor) 
	{
		// Lazily initialize selector view
		if(selectorView == null) {
			selectorView = new ContentSelectorView(controller);
		}
		
		selectorView.setReturnAnchor(returnAnchor);
		selectorView.refresh(data);
		rootContainer.setWidget(selectorView);
	}

	public void showSelectorViewForCategory(ContentCreateData data, String returnAnchor)
	{
		// Lazily initialize selector view
		if(selectorView == null) {
			selectorView = new ContentSelectorView(controller);
		}
		
		selectorView.setReturnAnchor(returnAnchor);
		selectorView.refresh(data);
		rootContainer.setWidget(selectorView);
	}
	
	public ContentCreateController getController() {
		return controller;
	}

	public void setController(ContentCreateController controller) {
		this.controller = controller;
	}

	/**
	 * Shows busy indicator
	 */
	public void showBusyIndicator() {
		busyIndicator.center();
	}
	
	/**
	 * Hides busy indicator
	 */
	public void hideBusyindicator() {
		busyIndicator.hide();
	}
	
	/**
	 * Shows empty view
	 */
	public void showEmptyView() {
		rootContainer.setWidget(emptyPanel);
	}

	/**
	 * Shows etrror message
	 * @param error
	 */
	public void showError(String error) {
		//TODO: Properly display error
		Window.alert("Error: " + error);
	}

	
	// Handles clicks on Cancel button
	class TitleViewCancelHandler implements ViewCancelHandler 
	{
		private String returnAnchor;
		
		public TitleViewCancelHandler(String returnAnchor)
		{
			this.returnAnchor = returnAnchor;
		}
		
		@Override
		public void onCancel(ViewCancelEvent event) 
		{
			History.newItem(returnAnchor);
		}
	}
	
}
