package com.tandbergtv.cms.portal.content.client.title.view;

import java.util.List;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.Anchors;
import com.tandbergtv.cms.portal.content.client.create.model.ContentCreateData;
import com.tandbergtv.cms.portal.content.client.create.model.TitleViewData;
import com.tandbergtv.cms.portal.content.client.create.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.create.model.UISourcePartner;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * A view to select a source provider and content class before creating a title. 
 * @author eyevkar
 */
public class ContentSelectorView extends Composite 
{
	private static final String TAB_NAME = "Content Selector";
	
	private String returnAnchor = Anchors.CONTENT_SEARCH_ANCHOR;
	
	// Root container
	private SimpleContainer rootContainer;

	private ListBox lbSourcePartner;
	private ListBox lbContentClass;
	
	private ContentCreateData data;
	
	
	/**
	 * Constructor
	 */
	public ContentSelectorView(final ContentCreateController controller) 
	{
		rootContainer = new SimpleContainer();
		this.initWidget(rootContainer);
		this.addStyleName("ContentSelectorView");
		
		VerticalPanel vp = new VerticalPanel();
		vp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
		
		// Screen Title
		HeaderPanel header = new HeaderPanel("Create Content"); 
		vp.add(header);
		
		// Content Provider and Content Class dropdowns
		FlexTable dropdownPanel = new FlexTable();
		dropdownPanel.setCellSpacing(10);
		
		// Row 1: Source Provider
		lbSourcePartner = new ListBox();
		lbSourcePartner.addChangeHandler(new ChangeHandler() {
			@Override
			public void onChange(ChangeEvent event) {
				// Get selected partner id
				String strPartnerId = lbSourcePartner.getValue(lbSourcePartner.getSelectedIndex());
				// Clear content class list
				lbContentClass.clear();
				// Add content classes from selected partner
				UISourcePartner partner = data.getSourcePartnerById(strPartnerId);
				addClasses(partner);
			}
		});
		
		dropdownPanel.setWidget(0, 0, new Label("Content Provider:"));
		dropdownPanel.setWidget(0, 1, lbSourcePartner);
		
		// Row 2: Content Class
		lbContentClass = new ListBox();
		dropdownPanel.setWidget(1, 0, new Label("Content Class:"));
		dropdownPanel.setWidget(1, 1, lbContentClass);
				
		// Buttons
		ButtonWidget btnNext = new ButtonWidget("Next", new ClickHandler() 
		{
		    public void onClick(ClickEvent event) {
		    	String strPartnerId = lbSourcePartner.getValue(lbSourcePartner.getSelectedIndex());
		    	String strContentClassId = lbContentClass.getValue(lbContentClass.getSelectedIndex());
		    	
		    	try 
		    	{
		    		TitleViewData tvData = new TitleViewData();
		    		tvData.partnerId = Long.parseLong(strPartnerId);
		    		tvData.contentClassId = Long.parseLong(strContentClassId);
		    		UIContentClass cc = data.findContentClass(tvData.partnerId, tvData.contentClassId);
		    		if(cc != null)
		    		{
		    			tvData.contentClassTypeId = cc.typeId;
		    		}
		    		
		    		if(controller != null) 
		    		{
		    			controller.showTitleView(tvData, returnAnchor);
		    		}
		    	}
		    	catch(Exception ex) 
		    	{
		    		Window.alert("Please select a source partner and a content class");
		    		return;
		    	}
		    }
		});
		btnNext.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		
		ButtonWidget btnCancel = new ButtonWidget("Cancel", new ClickHandler() 
		{
		    public void onClick(ClickEvent event) 
		    {
		    	History.newItem(returnAnchor);
		    }
		});
		btnCancel.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		
		ResizableContainer resizableContainer = new ResizableContainer(dropdownPanel, TAB_NAME, null);
		resizableContainer.addHeightOffsettingWidget(header);
		resizableContainer.addButton(TAB_NAME, btnNext);
		resizableContainer.addButton(TAB_NAME, btnCancel);
		
		vp.add(resizableContainer);
		
		rootContainer.setWidget(vp);
	}
	
	
	public void setReturnAnchor(String anchor)
	{
		this.returnAnchor = (anchor == null || anchor.trim().length() < 1) ? Anchors.CONTENT_SEARCH_ANCHOR : anchor; 
	}
	
	public String getReturnAnchor()
	{
		return returnAnchor;
	}
	
	
	/**
	 * Refresh dropdown boxes
	 * @param data
	 */
	public void refresh(ContentCreateData data) 
	{
		this.data = data;
		
		// Clear dropdowns
		lbSourcePartner.clear();
		lbContentClass.clear();
		
		// Populate partner dropdown
		List<UISourcePartner> partners = data.getSourcePartnerList();
		if(partners != null && !partners.isEmpty()) 
		{
			for(UISourcePartner partner: partners) 
			{
				lbSourcePartner.addItem(partner.getDisplayName(), ""+partner.getId());
			}
		}
		
		// Populate content class dropdown
		// Get first partner 
		UISourcePartner partner = null;
		if(partners != null && !partners.isEmpty()) 
		{
			partner = partners.get(0);
		}
		
		// Get content classes for the partner
		addClasses(partner);
	}
	
	private void addClasses(UISourcePartner partner) 
	{
		if(partner == null) return;
		
		List<UIContentClass> classes = partner.getContentClassList();
		if(classes != null && !classes.isEmpty()) 
		{
			for(UIContentClass cc: classes)
			{
				lbContentClass.addItem(cc.name, ""+cc.id);
			}
		}
	}
}
