/*
 * Created on Apr 30, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasViewCancelHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * The Error Panel is used to report the error back to the user along with a button allowing the
 * user to refresh the state.
 * 
 * @author Vijay Silva
 */
public class TitleErrorPanel extends Composite implements HasViewCancelHandlers {

	/* Styles */
	private static final String STYLE_NAME = "content-TitleErrorPanel";
	private static final String STYLE_LABEL = "content-TitleErrorPanel-message";
	private static final String STYLE_BUTTON = "content-TitleErrorPanel-button";

	/* Properties */
	private String errorMessage;
	private List<EventListener> listeners = new ArrayList<EventListener>();

	/* Widget */
	private SimpleContainer rootContainer;
	private HorizontalContainer buttonContainer;
	private VerticalContainer container;
	private boolean showCancel = false;

	/**
	 * Constructor
	 */
	public TitleErrorPanel(String message) {
		this(message, false);
	}

	/**
	 * Constructor
	 */
	public TitleErrorPanel(String message, boolean showCancel) {
		errorMessage = message;
		this.showCancel = showCancel;
		initialize();
	}

	/* Initialize the widgets on this panel */
	protected void initialize() {
		TitleViewMessages messages = TitleViewMessageCache.getMessages();

		rootContainer = new SimpleContainer();
		rootContainer.addStyleName(STYLE_NAME);
		initWidget(rootContainer);

		container = new VerticalContainer();
		rootContainer.setWidget(container);

		LabelWidget label = new LabelWidget(errorMessage);
		label.addStyleName(STYLE_LABEL);
		container.add(label);

		buttonContainer = new HorizontalContainer();
		container.add(buttonContainer);

		String text = messages.refreshButtonLabel();
		ButtonWidget button = new ButtonWidget(text);
		button.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
		button.addStyleName(STYLE_BUTTON);
		button.addClickHandler(new ClickHandler() {
			/* The refresh button */
			public void onClick(ClickEvent event) {
				fireRefreshClicked();
			}
		});
		buttonContainer.add(button);

		/* Add cancel button if required */
		if (showCancel) {
			String cancelText = messages.cancelButton();
			ButtonWidget cancelButton = new ButtonWidget(cancelText);
			cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
			cancelButton.addStyleName(STYLE_BUTTON);
			cancelButton.addClickHandler(new ClickHandler() {
				/* The refresh button */
				public void onClick(ClickEvent event) {
					fireCancelClicked();
				}
			});
			buttonContainer.add(cancelButton);
		}
	}

	/* Fire the event to all listeners */
	private void fireRefreshClicked() {
		for (EventListener listener : listeners) {
			listener.onRefreshClicked(this);
		}
	}

	/* Fire the event to all listeners */
	private void fireCancelClicked() {
		fireEvent(new ViewCancelEvent());
	}

	@Override
	public HandlerRegistration addViewCancelHandler(ViewCancelHandler handler) {
		return addHandler(handler, ViewCancelEvent.getType());
	}

	/**
	 * Add an event listener for this error panel
	 * 
	 * @param listener The event listener
	 */
	public void addEventListener(EventListener listener) {
		if (listener != null)
			listeners.add(listener);
	}

	/**
	 * Remove an event listener for this error panel
	 * 
	 * @param listener The event listener
	 */
	public void removeEventListener(EventListener listener) {
		listeners.remove(listener);
	}

	/**
	 * Interface for the Error Panel event listening
	 */
	public interface EventListener {

		/**
		 * The Refresh button displayed on the error panel is clicked.
		 * 
		 * @param panel The error panel
		 */
		public void onRefreshClicked(TitleErrorPanel panel);
	}
}
