/*
 * Created on May 1, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleOverview;
import com.tandbergtv.cms.portal.content.client.title.view.thumbnail.TitleThumbnailWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * The heading widget for the title view
 * 
 * @author Vijay Silva
 */
public class TitleViewHeaderWidget extends Composite {

	/* Properties */
	private final SimpleContainer container;
	private final TitleView view;
	private HorizontalContainer outerContents, contents;
	private UITitleOverview input;
	private ImageWidget titleTypeImage, statusImage, distributionStatusImage;
	private ImageWidget originalDifferenceImage, distributionDifferenceImage;
	private SimpleContainer thumbnailHolder;
	private TitleThumbnailWidget thumbnailImage;

	private LabelWidget headingLabel, statusLabel, contentClassLabel;
	
	private boolean showStatusImage = true;

	private static final String STYLE_NWT_HEADER = "nwt-HeaderPanel";
	private static final String STYLE_NAME = "content-TitleViewHeaderWidget";
	private static final String STYLE_CONTENTS = "content-TitleViewHeaderWidget-contents";
	private static final String STYLE_NWT_HEADING_LABEL = "nwt-HeaderPanel-label";
	private static final String STYLE_HEADING_LABEL = "content-TitleViewHeaderWidget-headingLabel";
	private static final String STYLE_ICON = "content-TitleViewHeaderWidget-icon";
	private static final String STYLE_TITLE_TYPE_ICON = "content-TitleViewHeaderWidget-typeIcon";
	private static final String STYLE_TITLE_THUMBNAIL = "content-TitleViewHeaderWidget-thumbnail";
	private static final String STYLE_STATUS_ICON = "content-TitleViewHeaderWidget-statusIcon";
	private static final String STYLE_STATUS_LABEL = "content-TitleViewHeaderWidget-statusLabel";
	private static final String STYLE_DISTRIBUTION_STATUS_ICON = "content-TitleViewHeaderWidget-distributionStatusIcon";
	private static final String STYLE_ORIGINAL_DIFF_ICON = "content-TitleViewHeaderWidget-orginalCompareIcon";
	private static final String STYLE_SITE_DIFF_ICON = "content-TitleViewHeaderWidget-siteCompareIcon";
	private static final String CONTENT_VIEW_ANCHOR = "Content.Search.Id=";
	private static final String STYLE_IMAGE_LINK = "imageLink";

	/**
	 * Constructor
	 * 
	 * @param parent The title view
	 */
	public TitleViewHeaderWidget(TitleView parentView) {
		this.view = parentView;
		container = new SimpleContainer();
		initWidget(container);
		initialize();
	}

	/*
	 * Initialize the widget
	 */
	private void initialize() {
		addStyleName(STYLE_NWT_HEADER);
		addStyleName(STYLE_NAME);

		/* Build content widget */
		outerContents = new HorizontalContainer();
		container.add(outerContents);
		contents = new HorizontalContainer();
		contents.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		contents.addStyleName(STYLE_CONTENTS);
		outerContents.add(contents);

		titleTypeImage = new ImageWidget();
		titleTypeImage.addStyleName(STYLE_ICON);
		titleTypeImage.addStyleName(STYLE_TITLE_TYPE_ICON);
		titleTypeImage.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				handleTitleTypeImageClick();
			}
		});

		thumbnailHolder = new SimpleContainer();
		thumbnailHolder.setStyleName(STYLE_TITLE_THUMBNAIL);
		thumbnailImage = new TitleThumbnailWidget();
		thumbnailImage.addStyleName(STYLE_ICON);
		thumbnailHolder.setWidget(thumbnailImage);

		contentClassLabel = new LabelWidget();
		contentClassLabel.addStyleName(STYLE_HEADING_LABEL);

		headingLabel = new LabelWidget();
		headingLabel.addStyleName(STYLE_NWT_HEADING_LABEL);
		headingLabel.addStyleName(STYLE_HEADING_LABEL);

		statusImage = new ImageWidget();
		statusImage.addStyleName(STYLE_ICON);
		statusImage.addStyleName(STYLE_STATUS_ICON);
		statusLabel = new LabelWidget();
		statusLabel.addStyleName(STYLE_STATUS_LABEL);

		distributionStatusImage = new ImageWidget();
		distributionStatusImage.addStyleName(STYLE_ICON);
		distributionStatusImage.addStyleName(STYLE_DISTRIBUTION_STATUS_ICON);
		distributionStatusImage.addClickHandler(new ClickHandler()
		{
			@Override
			public void onClick(ClickEvent event)
			{
				handleDistributionStatusImageClick();
			}
		});


		originalDifferenceImage = new ImageWidget();
		originalDifferenceImage.addStyleName(STYLE_ICON);
		originalDifferenceImage.addStyleName(STYLE_ORIGINAL_DIFF_ICON);
		originalDifferenceImage.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				handleOriginalDifferenceImageClick();
			}
		});

		distributionDifferenceImage = new ImageWidget();
		distributionDifferenceImage.addStyleName(STYLE_ICON);
		distributionDifferenceImage.addStyleName(STYLE_SITE_DIFF_ICON);
		distributionDifferenceImage.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				handleDistributionDifferenceImageClick();
			}
		});
	}

	/**
	 * @return the input
	 */
	public UITitleOverview getInput() {
		return input;
	}

	/**
	 * @param input the input to set
	 */
	public void setInput(UITitleOverview input) {
		this.input = input;
	}

	private TitleView getView() {
		return view;
	}

	/**
	 * Refresh to contents of this widget
	 */
	public void refresh() {
		contents.clear();
		titleTypeImage.removeStyleName(STYLE_IMAGE_LINK);
		originalDifferenceImage.removeStyleName(STYLE_IMAGE_LINK);
		distributionDifferenceImage.removeStyleName(STYLE_IMAGE_LINK);

		/* Check if input is present */
		if (getInput() == null) {
			return;
		}

        thumbnailImage.setInput(getInput().getId(), null);
        contents.add(thumbnailHolder);

		/* Add icon for type of title */
		String typeName = (getInput().isSiteTitle()) ? "siteTitle" : "originalTitle";
		view.getBundle().updateIcon(titleTypeImage, typeName);
		titleTypeImage.addStyleName(STYLE_ICON);
		titleTypeImage.addStyleName(STYLE_TITLE_TYPE_ICON);
		if (getInput().isSiteTitle()) {
			titleTypeImage.addStyleName(STYLE_IMAGE_LINK);
		}

		/* Add the heading message */
		//view.getInput().getContentClassName() gets the contentclass name from the specification
		//However, for some tabs,e.g MSOOveride and Series, getting the specification(just to get the contentclass name) is an overkill 
		//In those cases, we get the contentclass name from the UITitleOverview object (input). Not sure why in the first place, we don't get 
		//the content class name from UITitleOverview.
		String ccName = view.getInput().getContentClassName();
		if (ccName.isEmpty() && input.getContentClassName() != null)
		{
			ccName = input.getContentClassName();
		}
		contentClassLabel.setText("Content Class: " + ccName);
		
		String heading = getInput().getHeading();
		if (heading == null)
		{
			heading = "";
		}
		if (view.getInput().isBulkEdit()) 
		{
			// TODO move to message
			headingLabel.setText("Batch Edit:" + view.getInput().getOrderedBulkEditTitleIds());
		} 
		else 
		{
			headingLabel.setText(view.getViewMessages().titleDetails(heading));
		}

		VerticalPanel headerPanel = new VerticalPanel();
		headerPanel.add(contentClassLabel);

		HorizontalPanel titleDetailsPanel = new HorizontalPanel();
		if (view.getInput() == null || !view.getInput().isSeriesTitle())
		{
			titleDetailsPanel.add(titleTypeImage);
		}
		titleDetailsPanel.add(headingLabel);
		
		/* Add status icon or label */
		UITitleStatus titleStatus = getInput().getStatus();
		if(titleStatus == null)
		{
			titleStatus = UITitleStatus.DRAFT;
		}
		if(!view.getInput().isBulkEdit()) 
		{
			if(showStatusImage) 
			{
				view.getBundle().updateTitleStatusIcon(statusImage, titleStatus);
				statusImage.addStyleName(STYLE_ICON);
				statusImage.addStyleName(STYLE_STATUS_ICON);
				titleDetailsPanel.add(statusImage);
			} 
			else 
			{
				String name = view.getBundle().getStatusName(titleStatus);
				statusLabel.setText("[" + name + "]");
				titleDetailsPanel.add(statusLabel);
			}
		}
		
		// Add the site specific icons
		if(getInput().isSiteTitle()) 
		{
			/* Add distribution status icon */
			UIDistributionStatus status = getInput().getDistributionStatus();
			if (status == null) {
				status = UIDistributionStatus.TARGETED;
			}
			view.getBundle().updateDistributionStatusIcon(distributionStatusImage, status);
			distributionStatusImage.addStyleName(STYLE_ICON);
			distributionStatusImage.addStyleName(STYLE_DISTRIBUTION_STATUS_ICON);
			titleDetailsPanel.add(distributionStatusImage);

			/* Add original title change status icon */
			boolean different = getInput().isChangedAfterTargeting();
			String iconName = (different) ? "originalTitleDifferent" : "originalTitleNotDifferent";
			view.getBundle().updateIcon(originalDifferenceImage, iconName);
			originalDifferenceImage.addStyleName(STYLE_ICON);
			originalDifferenceImage.addStyleName(STYLE_ORIGINAL_DIFF_ICON);
			if (different) {
				originalDifferenceImage.addStyleName(STYLE_IMAGE_LINK);
			}
			titleDetailsPanel.add(originalDifferenceImage);

			/* Add distribution title change status icon */
			different = getInput().isChangedAfterDistribution();
			iconName = (different) ? "distributedTitleDifferent" : "distributedTitleNotDifferent";
			view.getBundle().updateIcon(distributionDifferenceImage, iconName);
			distributionDifferenceImage.addStyleName(STYLE_ICON);
			distributionDifferenceImage.addStyleName(STYLE_SITE_DIFF_ICON);
			if (different) 
			{
				distributionDifferenceImage.addStyleName(STYLE_IMAGE_LINK);
			}
			titleDetailsPanel.add(distributionDifferenceImage);
		}
		// Master PACKAGE title
		else
		{
			// Don't show this for SERIES title and for new unsaved titles (titleID == null)
			if(input != null && view.getInput() != null 
					&& !view.getInput().isSeriesTitle() && view.getInput().getTitleId() != null)
			{
				distributionStatusImage.addStyleName(STYLE_ICON);
				distributionStatusImage.addStyleName(STYLE_DISTRIBUTION_STATUS_ICON);
				distributionStatusImage.addStyleName(STYLE_IMAGE_LINK);

				if(input.isMasterTitleDistributionError())
				{
					ImageResource resource = (ImageResource)view.getBundle().getTitleBundle().distributionSiteError();
					distributionStatusImage.setResource(resource);
					distributionStatusImage.setTitle("Distribution error");
				}
				else
				{
					ImageResource resource = (ImageResource)view.getBundle().getTitleBundle().distributionSite();
					distributionStatusImage.setResource(resource);
					distributionStatusImage.setTitle("No distribution errors");
				}
				
				titleDetailsPanel.add(new HTML("<span>&nbsp;</span>"));
				titleDetailsPanel.add(distributionStatusImage);
			}			
		}
		
		headerPanel.add(titleDetailsPanel);
		contents.add(headerPanel);
	}

	/*
	 * Handle the original difference image click
	 */
	private void handleOriginalDifferenceImageClick() {
		if (getInput() == null || !getInput().isChangedAfterTargeting()) {
			return;
		}

		String version = getInput().getOriginalVersion();
		getView().showMasterTitleComparison(getInput().getOriginalId(), version);
	}

	/*
	 * Handle the distribution difference image click
	 */
	private void handleDistributionDifferenceImageClick() {
		if (getInput() == null || !getInput().isChangedAfterDistribution()) {
			return;
		}

		String version = getInput().getDistributedVersion();
		getView().showDistributedTitleComparison(getInput().getId(), version);
	}

	/*
	 * Handle the title type image click
	 */
	private void handleTitleTypeImageClick() 
	{
		if (getInput() == null || !getInput().isSiteTitle()
		        || !ClientAuthorizationManager.isAuthorized(Permissions.TITLE_VIEW)) {
			return;
		}

		/* Show the title view for the master title by firing anchor change */
		History.newItem(CONTENT_VIEW_ANCHOR + getInput().getOriginalId());
	}

	
	private void handleDistributionStatusImageClick()
	{
		// If it is a master title go to Sites tab
		if(!getInput().isSiteTitle())
		{
			History.newItem(CONTENT_VIEW_ANCHOR + getInput().getId() + "&Tab=Sites");
		}
	}


}
