/*
 * Created on Apr 28, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.i18n.client.Messages;

/**
 * Internationalized constants used in the Title View
 * 
 * @author Vijay Silva
 */
public interface TitleViewMessages extends Messages {

	/**
	 * Message indicating failure loading a specification
	 * 
	 * @param specificationName The specification name
	 * @param message The exception message
	 */
	public String specificationFetchFailure(String specificationName, String message);

	/**
	 * Message indicating failure loading the default specification
	 * 
	 * @param message The exception message
	 */
	public String defaultSpecificationFetchFailure(String message);

	/**
	 * Message indicating that there was an error loading the specification names
	 * 
	 * @param message
	 * @return
	 */
	public String specificationNamesFetchFailure(String message);

	/**
	 * The refresh button
	 */
	public String refreshButtonLabel();

	/**
	 * Message indicating that the title view action is not authorized
	 */
	public String viewAnchorInvalid(String fieldName);

	/**
	 * Message indicating that the title view action is not authorized
	 */
	public String viewNotAuthorized();

	/**
	 * Message indicating that the title create action is not authorized
	 */
	public String createNotAuthorized();
	
	/**
	 * Message indicating that the enhance metadata action is not authorized
	 */
	public String enhanceNotAuthorized();
	
	/**
	 * Get the metadata tab display name
	 */
	public String metadataTabName();

	/**
	 * Get the history tab display name
	 */
	public String historyTabName();

	/**
	 * Get the sites tab display name
	 */
	public String sitesTabName();

	/**
	 * Message indicating that the title metadata is loading
	 */
	public String metadataLoading();

	/**
	 * Message indicating failure getting the file paths from the server
	 */
	public String filePathsFetchFailure(String message);

	/**
	 * Message indicating failure getting the metadata from the server
	 */
	public String metadataFetchError(String message);

	/**
	 * Success saving the title
	 */
	public String titleSaveSuccessMessage();

	/**
	 * Failure saving the title
	 */
	public String titleSaveFailureMessage();

	/**
	 * Attempt to bulk edit a title that has been deleted
	 */
	public String bulkEditDeletedTitleFailureMessage();

	/**
	 * Failure saving the title because of rule validation failure (recoverable)
	 */
	public String titleSaveValidationFailureMessage();

	/**
	 * Failure saving the titles during bulk edit
	 */
	public String titleBulkEditFailureMessage();

	/**
	 * Failure saving the title because of non-validation error
	 */
	public String titleSaveGeneralFailureHeading();

	/**
	 * Heading message for validation view indicating title failed validation during save
	 */
	public String titleValidationFailureHeading();

	/**
	 * Heading message for validation view indicating title failed validation, but can be recovered
	 * with save as draft
	 */
	public String titleValidationFailureHeadingWithRecovery();

	/**
	 * Heading message for validation view indicating title failed validation during bulk edit
	 */
	public String titleValidationBulkFailureHeading();

	/**
	 * Heading message for validation view indicating title failed validation during bulk edit, but
	 * can recover with save as draft or current status
	 */
	public String titleValidationBulkFailureHeadingWithCurrentStatus();

	/**
	 * Heading message for validation view indicating title failed validation during bulk edit, but
	 * can recover with save as draft
	 */
	public String titleValidationBulkFailureHeadingWithDraftStatus();

	/**
	 * Message indicating that the title metadata is loading
	 */
	public String historyLoading();

	/**
	 * Message indicating failure getting the history from the server
	 */
	public String historyFetchFailure(String message);

	/**
	 * History not present for title
	 */
	public String historyNotPresent();

	
	/**
	 * History : User selected more than 2 revisions to compare 
	 */
	public String historyErrorMoreThanTwoRevisions();	

	/**
	 * History : User selected more than 2 revisions to compare 
	 */
	public String historyErrorLessThanTwoRevisions();	
	
	/**
	 * History : Messages used in Description column
	 */
	public String titleUpdatedMessage();
	public String titleNormalizedMessage();
	public String viewChangesMessage();
	
	/**
	 * History table column name for the user column
	 */
	public String progressTableUserColumn();

	/**
	 * History table column name for the user column
	 */
	public String progressTableActionColumn();

	/**
	 * History table column name for the description column
	 */
	public String progressTableDescriptionColumn();

	/**
	 * History table column name for the date column
	 */
	public String progressTableDateColumn();

	/**
	 * History table column name for the revision column
	 */
	public String progressTableRevisionColumn();

	/**
	 * The separator to use between the Source Component Name and the Source Entity Name
	 */
	public String sourceSeparator();

	/**
	 * The failure message when loading a title revision
	 */
	public String titleRevisionFetchError(String revision, String message);

	/**
	 * Message at the top of the revision panel showing the title revision number
	 */
	public String titleRevisionMessage(String revision);

	/**
	 * The text for enhance metadata On Save checkbox
	 */
	public String enhanceOnSaveCheck();

	/**
	 * The save button text
	 */
	public String saveButton();

	/**
	 * The save as draft button text
	 */
	public String saveAsDraftButton();

	/**
	 * The save all button text
	 */
	public String saveAllButton();

	/**
	 * The save all as draft button text
	 */
	public String saveAllAsDraftButton();

	/**
	 * The save as current status button text
	 */
	public String saveAsCurrentStatusButton();

	/**
	 * The cancel button text
	 */
	public String cancelButton();

	/**
	 * The map button text
	 */
	public String selectButton();

	/**
	 * The roll back button text
	 */
	public String rollbackButton();

	/**
	 * 
	 * The roll back as draft button 
	 */
	public String rollbackAsDraftButton();
	
	/**
	 * The compare button text
	 */
	public String compareButton();

	/**
	 * Message displayed in dialog box when preview fails
	 */
	public String previewError(String message);

	/**
	 * Description of title being previewed
	 */
	public String previewTitleDescriptionLabel();

	/**
	 * Description of title version being previewed
	 */
	public String previewTitleVersionDescriptionLabel(String version);

	/**
	 * Message indicating that the preview of a title is being generated
	 */
	public String previewTitleLoadingMessage();

	/**
	 * The preview button text
	 */
	public String previewButton();

	/**
	 * Title List
	 */
	public String titleList();
	
	public String seriesTitleList();

	/**
	 * Title Details
	 */
	public String titleDetails(String name);

	/**
	 * Message that is displayed when the title is successfully rolled back to a previous version.
	 */
	public String successfullRollbackMessage(String titleVersion);

	/**
	 * Message displayed in the dialog box when roll back failed due to a validation error.
	 */
	public String rollbackSaveAsDraftMessage(String titleVersion);

	/**
	 * Yes button text for roll back dialog box in case of validation errors
	 */
	public String rollbackDialogYes();

	/**
	 * No button text for roll back dialog box in case of validation errors
	 */
	public String rollbackDialogNo();

	/**
	 * Message when roll back fails and user has not selected to save title as a DRAFT.
	 */
	public String rollbackFailureMessage(String titleVersion);

	/*
	 * Message when roll back fails and the user cannot save as draft.
	 */
	public String rollbackValidationFailureMessage(String titleVersion);

	/**
	 * File Id
	 */
	public String fileIdColumn();

	/**
	 * Parent File Id
	 */
	public String parentFileIdColumn();

	/**
	 * The tool tip for the file URI widget for the file view
	 */
	public String fileURIWidgetToolTip();

	/**
	 * The tool tip for the file URI widget for the file view
	 */
	public String fileURIWidgetErrorToolTip();

	/**
	 * Error message when attempting to change the parent file of an existing file
	 */
	public String fileParentChangeError();

	/**
	 * Error message when attempting to set the parent of a file to one of its descendants.
	 */
	public String fileParentDescendantError();

	/**
	 * Error message when deleting an existing file (file saved in the DB)
	 */
	public String fileDeleteExistingError();

	/**
	 * Error message when deleting a file that has child files
	 */
	public String fileDeleteWithChildrenError();

	/**
	 * Error message when showing a metadata field defined with a data type that doesn't match the
	 * received data type.
	 * 
	 * @param typeName The defined data type for the field
	 * @param recievedTypeName The received data type for the field
	 */
	public String metadataTypeMismatchError(String typeName, String recievedTypeName);

	/**
	 * The title validation view section heading for the error section
	 * 
	 * @param count The number of error validation messages
	 */
	public String titleValidationErrorHeading(int count);

	/**
	 * The title validation view section heading for the error section
	 * 
	 * @param count The number of warning validation messages
	 */
	public String titleValidationWarningHeading(int count);

	/**
	 * The title validation view section heading for the information section
	 * 
	 * @param count The number of warning validation messages
	 */
	public String titleValidationInformationHeading(int count);

	/**
	 * The field name and asset type to display for the validation message
	 * 
	 * @param assetType The asset type
	 * @param fieldName The field name
	 */
	public String titleValidationMessageField(String assetType, String fieldName);

	/**
	 * The data type name to use for complex fields
	 */
	public String complexTypeName();

	/**
	 * The data type name for fields that cannot be determined
	 */
	public String unknownTypeName();

	/**
	 * The text for the 'Add' button in the metadata view
	 */
	public String fieldAddButton();

	/**
	 * The text for the 'Remove' button in the metadata view
	 */
	public String fieldRemoveButton();

	/**
	 * Generate the label for a simple field
	 * 
	 * @param displayName The display name for the field
	 */
	public String simpleFieldNameLabel(String displayName);

	/**
	 * Generate the label for a nullify check box in batch edit
	 */
	public String simpleFieldNullifyCheckBox();

	/**
	 * Generate the label for a auto-fill check box in batch edit
	 */
	public String simpleFieldAutoFillCheckBox();

	/**
	 * The field heading for the root field of the asset metadata
	 */
	public String metadataSectionHeading();

	/**
	 * The field heading for the files section of the asset metadata
	 */
	public String fileSectionHeading();

	public String fileUploadWidgetGettingConfError();
	
	public String fileUploadButtonText();
	
	/**
	 * The text for successful registration of uploaded file
	 */
	public String fileUploadResgisterSuccessful(String assetId);
		
	/**
	 * The text for error in registering uploaded file 
	 */
	public String fileUploadResgisterError(String assetId);	
	
	public String fileUploadCanceled(String assetId);
	
	public String fileUploadError(String assetId);
	
	public String fileUploadDisableMessage();

	public String fileUploadWithValidationErrors();
	/**
	 * The text for the 'Add' menu item in the context menu of asset tree
	 */
	String assetTreeMenuItemAddText();

	/**
	 * The text for the 'Remove' menu item in the context menu of asset tree
	 */
	String assetTreeMenuItemRemoveText();

	String assetTreeMenuItemSetImageFromKeyframesText();

	String assetTreeMenuItemSetMarkInMarkOutFromKeyframesText();

	String assetTreeMenuItemSetMarkInMarkOutFromVideoText();
	
	String assetTreeMenuItemCreateImageFromVideoText();

	String assetTreeMenuItemSetAvailTimeCodesFromVideoText();
	
	String assetTreeMenuItemSetImageFromSnapshotsText();
	
	String sitesFetchFailure(String errMsg);

	String distributionSitesNotPresent();

	String trackingSitesNotPresent();

	String trackingSitesFetchFailure(String errMsg);

	String distributionSitesFetchFailure(String errMsg);

	String distributionSiteFetchFailure(String errMsg);

	/**
	 * Title Sites messages
	 */
	String sitesLoading();

	String sitesPanelName();

	String sitesStatusDisclosurePanelName();

	String sitesManualTargetingDisclosurePanelName();

	String distributionSitesTableNameColumn();

	String distributionSitesTableTitleIdColumn();

	String distributionSitesTableStatusColumn();

	String distributionSitesTableDiffMasterColumn();

	String distributionSitesTableDiffDistributedColumn();

	String trackingSitesTableNameColumn();

	String trackingSitesTableTitleIdColumn();

	String trackingSitesTableParentNameColumn();

	String trackingSitesTableStatusColumn();

	String distributionSiteFilterLabel();

	String distributionSiteFilterForAll();

	String distributionSiteFilterButton();

	String targetingOptionLabel();

	String usingRulesOption();

	String selectSitesOption();

	String sitesSelectionLabel();

	String manualTargetingButton();

	String selectAtLeastOneSiteMessage();

	String targetConfirmationMessage();

	String targetSceduledMessage();

	String targetInitiatedMessage();

	String targetRulesNoSiteTargetedMessage();

	String masterTitleIdLabel();

	String distributionSiteLabel();

	String distributionStatusLabel();

	String differentFromMasterLabel();

	String differentFromLocalLabel();

	String trackingSitesColumnForLocalTable();

	String statusColumnForLocalTable();

	String compareTitleHeading();

	String compareMasterTitleHeading();

	String compareSiteTitleHeading();

	String compareRevisionHeading(String revision);

	String compareCurrentRevisionName();

	String compareRevisionName(String revision);

	String titleCompareSummaryMessage(String title1, String title2);

	
	/**
	 * Title Activity messages
	 */
	String activityLoading();

	String activityTabName();

	String currentActivityTableStatusColumn();

	String currentActivityTableWorkOrderIdColumn();

	String currentActivityTableCurrentTaskColumn();

	String currentActivityTableTemplateColumn();

	String currentActivityTableStartTimeColumn();

	String historyActivityTableStatusColumn();

	String historyActivityTableWorkOrderIdColumn();

	String historyActivityTableCurrentTaskColumn();

	String historyActivityTableTemplateColumn();

	String historyActivityTableStartTimeColumn();

	String historyActivityTableEndTimeColumn();

	String currentActivityLabel();

	String historyActivityLabel();

	String activityFetchFailure(String errMsg);

	String currentActivityNotPresent();

	String historyActivityNotPresent();
	
	String editImageButtonText();
	
	String previewImageButtontext();
	
	String editImageDialogBoxCaption();
	
	String previewImageDialogBoxCaption();

	String saveAsImageLabel();

	String lookupKeyLabel();
	
	String okButtonText();
	
	String cancelButtonText();
	
	String saveImageFailedMessage(String exception);
	
	String createSnapshotButtonText();

	String snapshotImageProcessInitiatedText();
	
	String videoSnapshotOkButtonText();
	
	String videoSnapshotCancelButtonText();
	
	/**
	 * Title Properties Messages
	 */
	public String propertiesTabName();
	public String propertiesLoading();
	public String propertiesFetchError(String error);

	/**
	 * Message providing the dirty tab marker
	 * 
	 * @return The marker for a dirty tab (used in tab name)
	 */
	public String tabDirtyMarker();

	/**
	 * Message asking the user to confirm that any changes on the tab made can be ignored when
	 * navigating away.
	 */
	public String tabConfirmIgnoreChangesMessage();

	/**
	 * Title MSO Overrides History Tab messages
	 */
	public String msoOverridesHistoryLoading();
	
	public String msoOverridesHistoryTabName();
	
	public String fieldNameColumn();
	
	public String originalValueColumn();
	
	public String overrideValueColumn();
	
	public String timeAppliedColumn();
	
	public String distributedVersionColumn();
	
	public String msoOverridesHistoryHeaderLabel();
	
	public String msoOverridesHistoryFetchFailure(String errMsg);
	
	public String msoOverridesHistoryNotPresent();
	
	public String noMSOs();

	public String action();
	
	/**
	 * Title Series Tab Messages
	 */
	public String seriesTabName();
	public String seriesLabelName();
	public String seasonLabelName();
	public String associateButtonText();
	public String disassociateButtonText();
	public String associateSuccessfulMessage();
	public String disassociateSuccessfulMessage();
	public String selectSeriesNameMessage();

	
	/**
	 * Series Title Episode Tab Messages
	 */
	public String episodesTabName();
	public String episodesTableTitleIdColumn();

	/// Rules preview tab
	public String rulesPreviewTabName();
	public String noMsoOverridesAvailable();
	public String meTemplateCancel();
	public String meTemplateDontEnhance();
	public String meTemplateConfirm();

}
