/*
 * Created on Jul 18, 2012
 * 
 * (C) Copyright Ericsson Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Event that indicates that the view has been changed by the user is some way causing the view to
 * have unsaved changes.
 * 
 * @author Vijay Silva
 */
public class ViewChangeEvent extends GwtEvent<ViewChangeHandler> {

	/* The Handler type */
	private static Type<ViewChangeHandler> TYPE;

	/**
	 * Constructor
	 */
	public ViewChangeEvent() {
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<ViewChangeHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<ViewChangeHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<ViewChangeHandler> getAssociatedType() {
		return getType();
	}

	@Override
	protected void dispatch(ViewChangeHandler handler) {
		handler.onViewChange(this);
	}
}
