package com.tandbergtv.cms.portal.content.client.title.view.activity;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelView;

abstract class ActivityItemColumn extends ColumnBase<String, ActivityItemRecord> {

	public ActivityItemColumn(String name, String displayName) {
		super(name, displayName);
	}
	
	@Override
	public View<String> getView(ActivityItemRecord record) {
		String text = getColumnText(record);

		/* Create the view */
		LabelStringView view = new LabelStringView(text);
		LabelWidget widget = view.getWidget();
		widget.addClickHandler(new RecordViewClickListener(view, this, record));

		return view;	
	}

	/*
	 * The View has been clicked
	 */
	private void fireViewClicked(LabelView<?> source, ActivityItemRecord record) {
		
	}	
	
	
	/**
	 * Get the text to display for this column when rendering the record for this column
	 * 
	 * @param record The record
	 */
	protected abstract String getColumnText(ActivityItemRecord record);
	
	/* Class that handles clicks for the view displayed by a column for a particular record */
	private class RecordViewClickListener implements ClickHandler {

		/* Properties */
		private LabelView<?> view;
		private ActivityItemRecord record;

		/**
		 * Constructor
		 */
		public RecordViewClickListener(LabelView<?> view, ActivityItemColumn column,ActivityItemRecord record) {
			this.view = view;
			this.record = record;
		}

		/**
		 * Handle the click of the view for a particular column and record
		 */
		public void onClick(ClickEvent event) {
			fireViewClicked(view, record);
		}
	}
	
}
