package com.tandbergtv.cms.portal.content.client.title.view.activity;

import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.tab.SucessPanel;
import com.tandbergtv.cms.portal.content.client.title.model.activity.UITitleActivity;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

class ActivityPanel extends SimpleContainer  {

	private TitleActivityTab parent;
	private VerticalContainer mainContainer;

	//widgets
	private SucessPanel currentActivityInfoPanel;
	private ErrorPanel currentActivityErrorPanel;
	private SucessPanel historyActivityInfoPanel;
	private ErrorPanel historyActivityErrorPanel;
	private CurrentActivityItemDataProvider dataProviderCurrentActivity;
	private Table<Long, ActivityItemRecord> tableCurrentActivity;
	private HistoryActivityItemDataProvider dataProviderHistoryActivity;
	private Table<Long, ActivityItemRecord> tableHistoryActivity;
	private HeaderPanel separator;
	private LabelWidget currentActivityLabel;
	private LabelWidget historyActivityLabel;
	
	private UITitleActivity activity = null;
	
	private static final int SPACING = 2;
	private static final String STYLE_NAME = "content-TitleListsPanel";
	
	public ActivityPanel(TitleActivityTab parent) {
		this.parent = parent;
		initWidgets();
		
		/* Show a blank label in the container */
		LabelWidget blankLabel = new LabelWidget("");
		this.setWidget(blankLabel);		
	}
	
	private void initWidgets() {
		mainContainer = new VerticalContainer();
		mainContainer.setSpacing(SPACING);
		mainContainer.setStylePrimaryName(STYLE_NAME);
		
		String message = parent.getViewMessages().currentActivityLabel();
		currentActivityLabel = new LabelWidget(message);		
		currentActivityInfoPanel = new SucessPanel();
		currentActivityInfoPanel.setVisible(false);
		currentActivityErrorPanel = new ErrorPanel();
		currentActivityErrorPanel.setVisible(false);
		dataProviderCurrentActivity = new CurrentActivityItemDataProvider(this);		
		tableCurrentActivity = new Table<Long, ActivityItemRecord>(dataProviderCurrentActivity);
		// page feature
		//PageFeature pageFeature = new PageFeatureImpl();
		//dataProviderCurrentActivity.setParentPageFeature(pageFeature);						 
		//tableCurrentActivity.addPageFeature(pageFeature);	
		
		separator = new HeaderPanel("");
		
		message = parent.getViewMessages().historyActivityLabel();
		historyActivityLabel = new LabelWidget(message);		
		historyActivityInfoPanel = new SucessPanel();
		historyActivityInfoPanel.setVisible(false);
		historyActivityErrorPanel = new ErrorPanel();
		historyActivityErrorPanel.setVisible(false);
		dataProviderHistoryActivity = new HistoryActivityItemDataProvider(this);
		tableHistoryActivity = new Table<Long, ActivityItemRecord>(dataProviderHistoryActivity);
		// page feature
		//pageFeature = new PageFeatureImpl();
		//dataProviderHistoryActivity.setParentPageFeature(pageFeature);						 
		//tableHistoryActivity.addPageFeature(pageFeature);
		
		mainContainer.add(currentActivityLabel);		
		mainContainer.add(currentActivityInfoPanel);		
		mainContainer.add(currentActivityErrorPanel);		
		mainContainer.add(tableCurrentActivity);		
		mainContainer.add(separator);		
		mainContainer.add(historyActivityLabel);		
		mainContainer.add(historyActivityInfoPanel);		
		mainContainer.add(historyActivityErrorPanel);		
		mainContainer.add(tableHistoryActivity);		
	}
	
	public UITitleActivity getUITitleActivity() {
		return activity;
	}
	
	private void refreshCurrentActivityTable(){
		if (!tableCurrentActivity.isInitialized()) {
			tableCurrentActivity.initialize(new NeptuneAsyncCallback<Void>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					tableCurrentActivity.refresh();
				}
			});
		} else {
			tableCurrentActivity.refresh();
		}
	}

	private void refreshHistoryActivityTable(){
		if (!tableHistoryActivity.isInitialized()) {
			tableHistoryActivity.initialize(new NeptuneAsyncCallback<Void>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					tableHistoryActivity.refresh();
				}
			});
		} else {
			tableHistoryActivity.refresh();
		}
	}
	
	
	void handleGetTitleActivityRecordsSuccess(UITitleActivity activity) {
		this.activity = activity;
		historyActivityErrorPanel.setVisible(false);
		currentActivityErrorPanel.setVisible(false);
		if (activity.getCurrentItems().size() == 0) {
			String message = parent.getViewMessages().currentActivityNotPresent();
			tableCurrentActivity.setVisible(false);
			currentActivityInfoPanel.setVisible(true);
			currentActivityInfoPanel.showSuccessMessage(message);
		} 
		else {
			tableCurrentActivity.setVisible(true);
			currentActivityInfoPanel.setVisible(false);
			currentActivityInfoPanel.reset();
			refreshCurrentActivityTable();
		}
		
		if (activity.getHistoryItems().size() == 0){
			String message = parent.getViewMessages().historyActivityNotPresent();
			tableHistoryActivity.setVisible(false);
			historyActivityInfoPanel.setVisible(true);
			historyActivityInfoPanel.showSuccessMessage(message);
		}
		else {
			tableHistoryActivity.setVisible(true);
			historyActivityInfoPanel.setVisible(false);
			historyActivityInfoPanel.reset();
			refreshHistoryActivityTable();
		}
		
		
		/* Show the main container if not already visible */
		if (getWidget() != mainContainer)
			setWidget(mainContainer);
	}

	void handleGetTitleActivityRecordsFailure(String errMsg) {
		historyActivityInfoPanel.setVisible(false);
		currentActivityInfoPanel.setVisible(false);
		tableCurrentActivity.setVisible(false);
		tableHistoryActivity.setVisible(false);
		
		historyActivityErrorPanel.setVisible(false);
		currentActivityErrorPanel.setVisible(true);
		currentActivityErrorPanel.showErrorMessage(errMsg);		
		
		/* Show the main container if not already visible */
		if (getWidget() != mainContainer)
			setWidget(mainContainer);
	}
	
}
