package com.tandbergtv.cms.portal.content.client.title.view.activity;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.portlet.PortletConstants;
import com.tandbergtv.cms.portal.content.client.title.model.activity.UIActivityItem;
import com.tandbergtv.cms.portal.content.client.title.model.activity.UITitleActivity;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

class HistoryActivityItemDataProvider implements DataProvider<Long, ActivityItemRecord> {
	private TitleViewMessages messages;
	private List<Column<?, ActivityItemRecord>> columns;
	private ActivityPanel parent;	
	private PageFeature parentPageFeature;
	private PortletConstants constants;
	
	/* Constants */
	public static final String STATUS_COLUMN_NAME = "status";
	public static final String WORKORDER_COLUMN_NAME = "workOrderId";
	public static final String CURRENT_TASK_COLUMN_NAME = "currentTask";
	public static final String TEMPLATE_COLUMN_NAME = "template";
	public static final String START_TIME_COLUMN_NAME = "startTime";
	public static final String END_TIME_COLUMN_NAME = "endTime";
	
	public HistoryActivityItemDataProvider(ActivityPanel parent) {
		this.parent = parent;
		constants = GWT.create(PortletConstants.class);

		/* Initialize the internationalized messages */
		messages = GWT.create(TitleViewMessages.class);

		/* Initialize the columns */
		initializeColumns();
	}	
	
	/* Initialize the columns */
	private void initializeColumns() {
		columns = new ArrayList<Column<?, ActivityItemRecord>>();
		String displayName = null;
		ActivityItemColumn column = null;
		final NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
		
		/* Status Column */
		columns.add(prepareStatusColumn());
				
		/* WorkOrder ID Column */
		displayName = messages.historyActivityTableWorkOrderIdColumn();
		column = new ActivityItemColumn(WORKORDER_COLUMN_NAME, displayName) {
			protected String getColumnText(ActivityItemRecord record) {
				return (record.getActivityItem().getWorkOrderId().toString());
			}

			public View<String> getView(final ActivityItemRecord record){
				return new View<String>() {
					@Override
					public String getStyleName() {
						return null;
					}
					
					@Override
					public Widget getWidget() {
						if(security.isUserInRole("WorkOrderManagement_View")) {						
							return new HyperlinkWidget(record.getActivityItem().getWorkOrderId().toString(), "Workflow.Work Orders.Search.Id=" + record.getActivityItem().getWorkOrderId());
						}
						else {
							return new LabelWidget(record.getActivityItem().getWorkOrderId().toString());
						}
					}

					@Override
					public void release() {
					}
				};
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		columns.add(column);
		
		/* Current Task Column */
		displayName = messages.historyActivityTableCurrentTaskColumn();
		column = new ActivityItemColumn(CURRENT_TASK_COLUMN_NAME, displayName) {
			protected String getColumnText(ActivityItemRecord record) {
				return (record.getActivityItem().getCurrentTask().toString());
			}
		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		columns.add(column);
		
		/* Template Column */
		displayName = messages.historyActivityTableTemplateColumn();
		column = new ActivityItemColumn(TEMPLATE_COLUMN_NAME, displayName) {
			protected String getColumnText(ActivityItemRecord record) {
				return (record.getActivityItem().getTemplate());
			}
		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		columns.add(column);
		
		/* Start Time Column */
		displayName = messages.historyActivityTableStartTimeColumn();
		column = new ActivityItemColumn(START_TIME_COLUMN_NAME, displayName) {
			protected String getColumnText(ActivityItemRecord record) {
				return getStartDateValue(record.getActivityItem());
			}
		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_DATE);
		columns.add(column);
		
		/* End Time Column */
		displayName = messages.historyActivityTableEndTimeColumn();
		column = new ActivityItemColumn(END_TIME_COLUMN_NAME, displayName) {
			protected String getColumnText(ActivityItemRecord record) {
				return getEndDateValue(record.getActivityItem());
			}
		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_DATE);
		columns.add(column);
	}	
	
	private Column<String, ActivityItemRecord> prepareStatusColumn() {
		ColumnBase<String, ActivityItemRecord> column = null;

		String displayName = messages.historyActivityTableStatusColumn();
		column = new ColumnBase<String, ActivityItemRecord>(STATUS_COLUMN_NAME, displayName) {
			@Override
			public View<String> getView(final ActivityItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return TableConstants.STYLE_DATA_LINK;
					}

					@Override
					public Widget getWidget() {
						String status = record.getActivityItem().getStatus();
						String statusToolTip = record.getActivityItem().getStatusToolTip();
						ImageWidget image = getImage(status, statusToolTip);  
						return image;
					}

					@Override
					public void release() {
					}
				};
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_ICON);
		
		return column;	
	}
	
	@Override
	public List<Column<?, ActivityItemRecord>> getColumns() {
		return this.columns;
	}

	@Override
	public void getRecord(Long key, AsyncCallback<ActivityItemRecord> callback) {
		/* should never be used */
		UIActivityItem activityItem = new UIActivityItem();
		activityItem.setId(key);
		callback.onSuccess(new ActivityItemRecord(activityItem));		
	}

	@Override
	public void getRecords(AsyncCallback<List<ActivityItemRecord>> callback) {
		UITitleActivity result =  parent.getUITitleActivity();				
		List<ActivityItemRecord> records = new ArrayList<ActivityItemRecord>();
		for (UIActivityItem activityItem : result.getHistoryItems()) {
					records.add(new ActivityItemRecord(activityItem));
		}
		callback.onSuccess(records);		
	}

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		/* do nothing */
		callback.onSuccess(null);		
	}

	@Override
	public boolean isCheckboxEnabled() {
		return false;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}

	/* Get the start date column value */
	private String getStartDateValue(UIActivityItem activityItem) {
		if (activityItem.getStartTime() == null) return null;
		return activityItem.getStartTime();
	}

	private String getEndDateValue(UIActivityItem activityItem) {
		if (activityItem.getEndTime() == null) return null;
		return activityItem.getEndTime();
	}
	
	/**
	 * @return the parentPageFeature
	 */
	public PageFeature getParentPageFeature() {
		return parentPageFeature;
	}

	/**
	 * @param parentPageFeature the parentPageFeature to set
	 */
	public void setParentPageFeature(PageFeature parentPageFeature) {
		this.parentPageFeature = parentPageFeature;
	}

	private ImageWidget getImage(String stateName, String toolTip) {
		ImageWidget image = new ImageWidget("images/icon_rect_" + stateName + ".gif");
		if(toolTip == null)
			image.setTitle(getLocalizedStateName(stateName));
		else
			image.setTitle(toolTip);
		return image;
	}
	
	private String getLocalizedStateName(String stateName) {
		return constants.getString("status" + stateName);
	}	
}
