package com.tandbergtv.cms.portal.content.client.title.view.activity;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleActivityViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleActivityViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.RefreshWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshHandler;

public class TitleActivityTab extends TitleViewTab {
	/* The refresh period */
	private static final int DEFAULT_REFRESH_RATE = 180;
	private static final int MINIMUM_REFRESH_RATE = 30;
	
	/* Properties */
	private RefreshWidget<ActivityPanel> mainPanel;

	/* The title activity service */
	private ITitleActivityViewServiceAsync titleActivityViewService = GWT.create(ITitleActivityViewService.class);	

	/* Styles */
	private static final String STYLE_LOADING_LABEL = "content-TitleMetadataTab-loadingMessage";

	/** Tab Name */ 
	public static final String TAB_NAME = "Activity";

	/**
	 * Constructor
	 * 
	 * @param parent The parent view
	 */
	public TitleActivityTab(TitleView parent) {
		super(parent);
	}

	@Override
	protected void initialize() {
		addStyleDependentName("activity");

		ActivityPanel activityPanel = new ActivityPanel(this);
		mainPanel = new RefreshWidget<ActivityPanel>(activityPanel);
		mainPanel.setRefreshOnLoad(false);
		mainPanel.setRefreshPeriod(getRefreshPeriod());
		mainPanel.addRefreshHandler(new RefreshHandler() {
			@Override
			public void onRefresh(RefreshEvent event) {
				handleRefreshEvent(event);
			}
		});
		
		//Set default to masterSitesPanel;
		this.getContainer().setWidget(mainPanel);
	}

	@Override
	protected String getTabName() {
		return TAB_NAME;
	}

	@Override
	public String getTabDisplayName() {
		return getViewMessages().activityTabName();
	}

	@Override
	public void refreshTab() 
	{
		// Clear message panel
		getTitleView().showMessage(null);
		
		/* Show the busy indicator */
		showBusyIndicator();

		/* Show the loading message */
		showLoadingMessage();

		/* Get the data from the server */
		refreshPanel();		
	}

	private void showLoadingMessage() {
		/* Show a loading message as the main widget */
		String message = this.getViewMessages().activityLoading();
		LabelWidget label = new LabelWidget(message);
		label.addStyleName(STYLE_LOADING_LABEL);
		getContainer().setWidget(label);
	}	
	
	void refreshPanel() {
		Long titleId = getViewInput().getTitleId();
		titleActivityViewService.getTitleActivity(titleId, new NeptuneAsyncCallback<UITitle>() {
			/* Success getting title sites */
			public void onNeptuneSuccess(UITitle result) {
				mainPanel.getWidget().handleGetTitleActivityRecordsSuccess(result.getActivity());
				getContainer().setWidget(mainPanel);
				updateTitleHeader(result.getOverview());
				hideBusyIndicator();
			};

			/* Failure getting the title sites */
			public void onNeptuneFailure(Throwable caught) {
				if (caught instanceof ReadDeletedTitleException) {
					showSevereError(caught.getMessage());
				} else {
					String error = caught.getLocalizedMessage();
					String message = getViewMessages().activityFetchFailure(error);

					/* Show the error panel */
					showErrorPanel(message);
				}

				hideBusyIndicator();
			};
		});
	}
	
	
	// ========================================================================
	// ===================== AUTO REFRESH
	// ========================================================================
	/*
	 * Determine the refresh period
	 */
	private int getRefreshPeriod() {
		/* Determine the refresh rate */
		NeptuneApplication application = NeptuneApplication.getApplication();
		ContentComponent component = application.getComponent(ContentComponent.class);
		Integer refreshRateValue = component.getTitleSitesViewRefreshRate();
		int refreshRate = DEFAULT_REFRESH_RATE;
		try {
			if (refreshRateValue != null) {
				refreshRate = refreshRateValue;
				if (refreshRate < MINIMUM_REFRESH_RATE)
					refreshRate = MINIMUM_REFRESH_RATE;
			}
		} catch (Exception e) {
			refreshRate = DEFAULT_REFRESH_RATE;
		}

		return (refreshRate * 1000);
	}

	/*
	 * Handle the refresh event
	 */
	private void handleRefreshEvent(RefreshEvent event) {
		/* Determine if visible (the widget and all its parents must be visible) */
		boolean visible = true;
		Widget widget = this.getContainer().getWidget();
		while (widget != null && visible) {
			visible &= widget.isVisible();
			widget = widget.getParent();
		}

		/* Check if the widget needs to be refreshed from the server */
		if (visible) {
			refresh();
		}
	}
}
