package com.tandbergtv.cms.portal.content.client.title.view.asset;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.view.HasViewChangeHandlers;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.MetadataView;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileView;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class AssetContent extends Composite implements HasViewChangeHandlers {
	private SimpleContainer rootContainer;
	private VerticalContainer container;
	private final AssetInfo asset;
	private List<UIAssetFilePath> filePaths;
	private boolean readOnly;
	private MetadataView metadataView;
	private FileView fileView;
	private ViewChangeHandler handler = new EventHandler();

	private static final String STYLE_NAME = "content-AssetContent";
	
	public AssetContent(TitleView tView, AssetInfo assetInfo, List<UIAssetFilePath> filePaths) {
		this(tView, assetInfo, filePaths, false);
	}

	public AssetContent(TitleView tView, AssetInfo assetInfo, List<UIAssetFilePath> filePaths, boolean readOnly) {
		this.asset = assetInfo;
		this.filePaths = filePaths;
		this.readOnly = readOnly;
		
		rootContainer = new SimpleContainer();
		rootContainer.addStyleName(STYLE_NAME);
		container = new VerticalContainer();
		rootContainer.setWidget(container);
		initWidget(rootContainer);

		createMetadata(assetInfo);
		createFiles(tView, assetInfo);
	}

	private final void createMetadata(AssetInfo assetInfo) {
		metadataView = new MetadataView(asset.getDefinition(), readOnly, assetInfo.isBatchEdit());
		metadataView.addViewChangeHandler(handler);
		container.add(metadataView);
		metadataView.setInput(assetInfo);
	}

	private void createFiles(TitleView tView, AssetInfo asset) {
		if (asset.isBatchEdit() || asset.getDefinition().isHideFileView()) {
			return;
		}
		
		UIAssetFileDefinition fileDefinition = asset.getDefinition().getFileDefinition();
		fileView = new FileView(tView, fileDefinition, filePaths, readOnly);
		fileView.addViewChangeHandler(handler);
		if(!asset.isBatchEdit())
			container.add(fileView);
		fileView.setInput(asset);
	}

	public AssetInfo getAsset() {
		return asset;
	}

	/**
	 * Mark this content view as dirty
	 */
	public void markDirty() {
		if (fileView != null) {
			fileView.markDirty();
		}
	}

	// ========================================================================
	// ===================== METADATA VALIDATION
	// ========================================================================

	/**
	 * Validate the File View widgets, and return validation messages for each of the metadata
	 * widgets that fail validation.
	 * 
	 * @return the list of validation messages
	 */
	public List<AssetValidationMessage> validate(boolean draft) {
		List<AssetValidationMessage> messages = new ArrayList<AssetValidationMessage>();
		metadataView.validate(messages, draft);
		if (fileView != null)
			fileView.validate(messages, draft);
		return messages;
	}

	/**
	 * Need to ensure that focus is set on the widget
	 */
	public void setFocus(Widget widget) {
		Widget parentWidget = widget.getParent();
		while (parentWidget != null && !parentWidget.equals(this)) {
			if (parentWidget instanceof DisclosureContainer) {
				((DisclosureContainer) parentWidget).setOpen(true);
			} else if (parentWidget instanceof DisclosurePanel) {
				((DisclosurePanel) parentWidget).setOpen(true);
			}

			parentWidget = parentWidget.getParent();
		}

		if (widget instanceof Focusable) {
			((Focusable) widget).setFocus(true);
		}
	}

	// ========================================================================
	// ===================== EVENT HANDLING
	// ========================================================================

	@Override
	public HandlerRegistration addViewChangeHandler(ViewChangeHandler handler) {
		return addHandler(handler, ViewChangeEvent.getType());
	}

	/*
	 * Internal event handler class for events handled by internal widgets
	 */
	private class EventHandler implements ViewChangeHandler {

		@Override
		public void onViewChange(ViewChangeEvent event) {
			/* Pass the event up */
			fireEvent(event);
		}
	}
}
