/*
 * Created on Oct 1, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIItemAsset;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.content.client.title.view.thumbnail.TitleThumbnailWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIAssetDefinitionVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIItemAssetDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

/**
 * Builds the Tree Item for an Asset Info object, and recursively builds the child tree nodes based
 * on the asset definition and the asset present in the AssetInfo object.
 * 
 * @author Vijay Silva
 */
public class AssetTreeItemBuilder implements IUIAssetDefinitionVisitor {

	protected transient AssetInfo parentAssetInfo;
	protected transient TreeItem parentTreeItem;

	private static final String STYLE_ITEM = "content-AssetTree-item";
	private static final String STYLE_ITEM_LABEL = "content-AssetTree-itemLabel";
	private static final String STYLE_ITEM_THUMBNAIL = "content-AssetTree-itemThumbnail";

	/**
	 * Constructor
	 */
	public AssetTreeItemBuilder() {
	}

	/**
	 * Build the tree item for the asset info provided, and recursively build any child nodes
	 */
	public TreeItem buildTreeItem(AssetInfo assetInfo) {
		/* Build the tree item */
		TreeItem item = new TreeItem(buildTreeItemWidget(assetInfo));
		item.setUserObject(assetInfo);

		/* Build the child tree items and ensure that the tree item is 'open' */
		buildChildTreeItems(item, assetInfo);
		item.setState(true);

		/* Return the built item */
		return item;
	}

	/*
	 * Build the tree item widget for the asset info
	 */
	private Widget buildTreeItemWidget(AssetInfo assetInfo) {
		HorizontalContainer container = new HorizontalContainer();
		container.addStyleName(STYLE_ITEM);
		container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);

		Label label = new LabelWidget(assetInfo.getDefinition().getDisplayName());
		label.addStyleName(STYLE_ITEM_LABEL);
		container.add(label);

		if (assetInfo.getAsset().isThumbnailAvailable()) {
			TitleThumbnailWidget thumbnail = new TitleThumbnailWidget();
			thumbnail.addStyleName(STYLE_ITEM_THUMBNAIL);
			thumbnail.setInput(assetInfo.getInput().getTitleId(), assetInfo.getAsset().getId());
			container.add(thumbnail);
		}

		return container;
	}

	/*
	 * Build the child tree items for the currently built tree item
	 */
	protected void buildChildTreeItems(TreeItem treeItem, AssetInfo assetInfo) {
		UIAssetDefinition definition = assetInfo.getDefinition();
		if (definition instanceof UIGroupAssetDefinition) {
			UIGroupAssetDefinition groupDefinition = (UIGroupAssetDefinition) definition;
			for (UIAssetDefinition childDefinition : groupDefinition.getChildren()) {
				this.parentAssetInfo = assetInfo;
				this.parentTreeItem = treeItem;
				childDefinition.accept(this);
				this.parentAssetInfo = null;
				this.parentTreeItem = null;
			}
		}
	}

	@Override
	public void visit(UIGroupAssetDefinition assetDefinition) {
		AssetInfo parentAssetInfo = this.parentAssetInfo;
		TreeItem parentTreeItem = this.parentTreeItem;
		UIGroupAsset parentAsset = (UIGroupAsset) parentAssetInfo.getAsset();

		/* Found a group child definition, build all required asset info objects */
		for (UIGroupAsset asset : parentAsset.getChildGroups(assetDefinition.getAssetType())) {
			AssetInfo childAssetInfo = new AssetInfo(parentAssetInfo.getInput(), asset,
			        assetDefinition, parentAssetInfo.isBatchEdit());
			parentTreeItem.addItem(buildTreeItem(childAssetInfo));
		}
	}

	@Override
	public void visit(UIItemAssetDefinition assetDefinition) {
		AssetInfo parentAssetInfo = this.parentAssetInfo;
		TreeItem parentTreeItem = this.parentTreeItem;
		UIGroupAsset parentAsset = (UIGroupAsset) parentAssetInfo.getAsset();

		/* Found a group child definition, build all required asset info objects */
		for (UIItemAsset asset : parentAsset.getChildItems(assetDefinition.getAssetType())) {
			AssetInfo childAssetInfo = new AssetInfo(parentAssetInfo.getInput(), asset,
			        assetDefinition, parentAssetInfo.isBatchEdit());
			parentTreeItem.addItem(buildTreeItem(childAssetInfo));
		}
	}
}
