/*
 * Created on Jul 14, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;

/**
 * @author Vijay Silva
 */
public class AssetValidationMessage {

	/* Properties */
	private AssetInfo asset;
	private String fieldName;
	private Widget fieldWidget;
	private String message;

	/**
	 * Constructor
	 */
	public AssetValidationMessage(AssetInfo asset, String fieldName, Widget fieldWidget,
	        String message) {
		this.asset = asset;
		this.fieldName = fieldName;
		this.fieldWidget = fieldWidget;
		this.message = message;
	}

	/**
	 * Get the asset which contains this metadata field that failed validation
	 * 
	 * @return The asset
	 */
	public AssetInfo getAsset() {
		return this.asset;
	}

	/**
	 * @return the fieldName
	 */
	public String getFieldName() {
		return fieldName;
	}

	/**
	 * @return the fieldWidget
	 */
	public Widget getFieldWidget() {
		return fieldWidget;
	}

	/**
	 * Get the validation message for this widget
	 * 
	 * @return The validation message
	 */
	public String getMessage() {
		return this.message;
	}
}
