/*
 * Created on Jul 7, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;

/**
 * Exception indicating that the metadata data type defined in the configuration doesn't match the
 * metadata data type specified by metadata manager.
 * 
 * @author Vijay Silva
 */
public class MetadataTypeMismatchException extends RuntimeException {

	/* Serialization UID */
	private static final long serialVersionUID = 7381248275676186472L;
	private String fieldName = null;
	private UIFieldDefinition fieldDefinition = null;
	private UIField receivedField = null;

	/**
	 * @param definition The field definition that is expected
	 * @param receivedField The field matched for rendering which doesn't match the definition
	 */
	public MetadataTypeMismatchException(String fieldName, UIFieldDefinition definition,
	        UIField receivedField) {
		this.fieldDefinition = definition;
		this.receivedField = receivedField;
	}

	/**
	 * @return the fieldName
	 */
	public String getFieldName() {
		return fieldName;
	}

	/**
	 * @return the fieldDefinition
	 */
	public UIFieldDefinition getFieldDefinition() {
		return fieldDefinition;
	}

	/**
	 * @return the receivedField
	 */
	public UIField getReceivedField() {
		return receivedField;
	}

	/**
	 * Generates a message containing the field name, received type and expected type
	 */
	@Override
	public String getMessage() {
		String msg = "File metadata field: " + fieldName + " is defined as "
		        + getExpectedTypeName() + " data type but the field received is "
		        + getReceivedTypeName() + " data type.";
		return msg;
	}

	/*
	 * Get the name of the expected data type
	 */
	private String getExpectedTypeName() {
		String name = null;
		if (fieldDefinition instanceof UIComplexFieldDefinition) {
			name = "complex";
		} else if (fieldDefinition instanceof UISimpleFieldDefinition) {
			name = ((UISimpleFieldDefinition) fieldDefinition).getDatatype().getName();
		} else {
			name = "unknown";
		}

		return name;
	}

	/*
	 * Get the name of the received data type
	 */
	private String getReceivedTypeName() {
		String name = null;
		if (receivedField instanceof UIComplexField) {
			name = "complex";
		} else if (receivedField instanceof UISimpleField) {
			name = ((UISimpleField<?>) receivedField).getDatatype().getName();
		} else {
			name = "unknown";
		}

		return name;
	}
}
