/*
 * Created on Jul 28, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset.field;

import java.util.List;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.cms.portal.content.client.title.view.HasViewChangeHandlers;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex.MetadataFieldWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * The Metadata View that displays the asset metadata
 * 
 * @author Vijay Silva
 */
public class MetadataView extends Composite implements HasViewChangeHandlers {

	/* Widget */
	private SimpleContainer container;
	private MetadataFieldWidget widget;

	/* Model */
	private UIAssetDefinition assetDefinition;
	private boolean readOnly;
	private AssetInfo asset;

	/* Style Names */
	private static final String STYLE_NAME = "content-MetadataView";

	/**
	 * Constructor
	 */
	public MetadataView(UIAssetDefinition assetDefinition, boolean readOnly, boolean isBatch) {
		this.assetDefinition = assetDefinition;
		this.readOnly = readOnly;

		container = new SimpleContainer();
		container.setStyleName(STYLE_NAME);
		initWidget(container);

		initialize(isBatch);
	}

	private void initialize(boolean isBatch) {
		this.widget = new MetadataFieldWidget(this.assetDefinition, this.readOnly, isBatch);
		widget.addViewChangeHandler(new ViewChangeHandler() {

			@Override
			public void onViewChange(ViewChangeEvent event) {
				/* Pass the event up */
				fireEvent(event);
			}
		});
		container.add(widget);
	}

	// ========================================================================
	// ===================== UPDATING INPUT
	// ========================================================================

	/**
	 * Set the input asset for this view
	 * 
	 * @param asset The asset for which the files need to be displayed
	 */
	public void setInput(AssetInfo asset) {
		this.asset = asset;
		widget.setInput(asset, asset.getAsset().getRootField());
	}

	/**
	 * @return the asset
	 */
	public AssetInfo getAsset() {
		return asset;
	}

	/**
	 * @return the assetDefinition
	 */
	public UIAssetDefinition getAssetDefinition() {
		return assetDefinition;
	}

	/**
	 * @return the readOnly
	 */
	public boolean isReadOnly() {
		return readOnly;
	}

	// ========================================================================
	// ===================== REFRESHING VIEW
	// ========================================================================

	/**
	 * Refresh the view.
	 */
	public void refresh() {
		widget.refresh();
	}

	// ========================================================================
	// ===================== METADATA VALIDATION
	// ========================================================================

	/**
	 * Validate the widgets, and return validation messages for each of the metadata widgets that
	 * fail validation.
	 * 
	 * @param messages the list of validation messages
	 */
	public void validate(List<AssetValidationMessage> messages,boolean draft) {
		widget.validate(messages,draft);
	}

	// ========================================================================
	// ===================== EVENT HANDLING
	// ========================================================================

	@Override
	public HandlerRegistration addViewChangeHandler(ViewChangeHandler handler) {
		return addHandler(handler, ViewChangeEvent.getType());
	}
}
