/*
 * Created on Jul 2, 2009
 *
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset.field;

import java.util.ArrayList;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.IVodPlaylistService;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.IVodPlaylistServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIBooleanField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIDateField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIFloatField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIIntegerField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.BooleanFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.DateFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.FloatFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.IntegerFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.SimpleFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.StringFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.TimeFieldWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIFieldDefinitionVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DateWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DefaultDataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.TimeWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.WidgetConfiguration;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * Builder that creates the widgets for simple fields
 *
 * @author Vijay Silva
 */
public abstract class MetadataWidgetBuilder implements IUIFieldDefinitionVisitor {

	/* The factory to build widgets */
	protected DataTypeWidgetFactory factory;

	/* The context state required by the visitor */
	protected UISimpleFieldDefinition simpleFieldDefinition = null;
	protected UIField field = null;
	protected SimpleFieldWidget<?, ?, ?> builtWidget = null;
	protected boolean readOnly = false;
	private static final String VOD_PLAYLIST_FIELD_NAME = "/Fields/VodPlaylistId";

	private IVodPlaylistServiceAsync VodPlaylistService = GWT.create( IVodPlaylistService.class );

	/**
	 * Constructor
	 */
	public MetadataWidgetBuilder() {
		initializeFactory();
	}

	/**
	 * Build the factory to use for building the widgets
	 *
	 * @return The factory
	 */
	protected void initializeFactory() {
		this.factory = new DefaultDataTypeWidgetFactory();
	}

	/**
	 * Build the widget for the given field definition
	 *
	 * @param fieldDefinition The simple field definition
	 * @param field The simple field for which to build the widget
	 * @param readOnly flag indicating if the widget is read only
	 */
	public SimpleFieldWidget<?, ?, ?> build(UISimpleFieldDefinition fieldDefinition, UIField field,
			boolean readOnly) {
		/* Set the context state for the widget being built */
		this.simpleFieldDefinition = fieldDefinition;
		this.field = field;
		this.readOnly = readOnly;

		/* Build the widget */
		this.simpleFieldDefinition.accept(this);
		return getBuiltWidget();
	}

	/*
	 * Get the built widget
	 */
	protected SimpleFieldWidget<?, ?, ?> getBuiltWidget() {
		SimpleFieldWidget<?, ?, ?> widget = builtWidget;

		/* Clear all context data and the built widget */
		this.simpleFieldDefinition = null;
		this.field = null;
		this.readOnly = false;
		this.builtWidget = null;

		return widget;
	}

	@Override
	public void visit(UIComplexFieldDefinition definition) {
		builtWidget = null;
		throw new MetadataTypeMismatchException(definition.getName(), definition, field);
	}

	@Override
	public void visit(UIBooleanFieldDefinition definition) {
		/* Build the widget */
		UIBooleanField field = getSimpleField(definition, this.field, UIBooleanField.class);

		WidgetConfiguration configuration = new WidgetConfiguration(definition);
		configuration.sortOptions();
		
		// Read only flag
		boolean fieldReadOnly = readOnly;
		if(!readOnly && definition.isLocked()) fieldReadOnly = true;
		configuration.setReadOnly(fieldReadOnly);

		DataTypeWidget<Boolean> typedWidget = factory.createBooleanWidget(configuration);

		this.initializeWidgetValue(typedWidget, field);
		BooleanFieldWidget widget = new BooleanFieldWidget(definition, field, typedWidget);
		widget.setReadOnly(fieldReadOnly);

		builtWidget = widget;
	}

	@Override
	public void visit(UIIntegerFieldDefinition definition) {
		/* Build the widget */
		UIIntegerField field = getSimpleField(definition, this.field, UIIntegerField.class);

		WidgetConfiguration configuration = new WidgetConfiguration(definition);
		configuration.sortOptions();
		
		// Read only flag
		boolean fieldReadOnly = readOnly;
		if(!readOnly && definition.isLocked()) fieldReadOnly = true;
		configuration.setReadOnly(fieldReadOnly);

		DataTypeWidget<Long> typedWidget = factory.createIntegerWidget(configuration);
		this.initializeWidgetValue(typedWidget, field);
		IntegerFieldWidget widget = new IntegerFieldWidget(definition, field, typedWidget);
		widget.setReadOnly(fieldReadOnly);

		builtWidget = widget;
	}

	@Override
	public void visit(UIFloatFieldDefinition definition) {
		/* Build the widget */
		UIFloatField field = getSimpleField(definition, this.field, UIFloatField.class);

		WidgetConfiguration configuration = new WidgetConfiguration(definition);
		configuration.sortOptions();
		
		// Read only flag
		boolean fieldReadOnly = readOnly;
		if(!readOnly && definition.isLocked()) fieldReadOnly = true;
		configuration.setReadOnly(fieldReadOnly);

		DataTypeWidget<String> typedWidget = factory.createFloatWidget(configuration);
		this.initializeWidgetValue(typedWidget, field);
		FloatFieldWidget widget = new FloatFieldWidget(definition, field, typedWidget);
		widget.setReadOnly(fieldReadOnly);

		builtWidget = widget;
	}

	@Override
	public void visit(UIDateFieldDefinition definition) {
		/* Build the widget */
		UIDateField field = getSimpleField(definition, this.field, UIDateField.class);
		DateWidgetConfiguration configuration = new DateWidgetConfiguration(definition);

		// Read only flag
		boolean fieldReadOnly = readOnly;
		if(!readOnly && definition.isLocked()) fieldReadOnly = true;
		configuration.setReadOnly(fieldReadOnly);

		DataTypeWidget<String> typedWidget = factory.createDateWidget(configuration);
		this.initializeWidgetValue(typedWidget, field);

		DateFieldWidget widget = new DateFieldWidget(definition, field, typedWidget);
		widget.setReadOnly(fieldReadOnly);

		builtWidget = widget;
	}

	@Override
	public void visit(UITimeFieldDefinition definition) {
		/* Build the widget */
		UITimeField field = getSimpleField(definition, this.field, UITimeField.class);
		TimeWidgetConfiguration configuration = new TimeWidgetConfiguration(definition);

		// Read only flag
		boolean fieldReadOnly = readOnly;
		if(!readOnly && definition.isLocked()) fieldReadOnly = true;
		configuration.setReadOnly(fieldReadOnly);

		
		DataTypeWidget<String> typedWidget;
		
		if("/Fields/Avails/Avail/TimeCodeOne".equals(definition.getXPath()) 
				|| "/Fields/Avails/Avail/TimeCodeTwo".equals(definition.getXPath())
				|| "/Fields/Avails/Avail/TimeCodeThree".equals(definition.getXPath())
				|| "/Fields/Avails/Avail/TimeCodeFour".equals(definition.getXPath())
		)
		{
			typedWidget = createTimeCodeWidget(configuration);
		}
		else
		{
			typedWidget = factory.createTimeWidget(configuration);
		}
		
		this.initializeWidgetValue(typedWidget, field);

		TimeFieldWidget widget = new TimeFieldWidget(definition, field, typedWidget);
		widget.setReadOnly(fieldReadOnly);

		builtWidget = widget;
	}

	private DataTypeWidget<String> createTimeCodeWidget(TimeWidgetConfiguration configuration)
	{
		IValueConverter<String> converter = new IValueConverter<String>()
		{
			public boolean validateTime(String value)
			{
				if(value.length() != 11) return false;
				
				if(value.charAt(2) != ':') return false;
				if(value.charAt(5) != ':') return false;
				if(value.charAt(8) != ':') return false;
				
				try
				{
					int hh = Integer.parseInt(value.substring(0,2));
					int mm = Integer.parseInt(value.substring(3,5));
					int ss = Integer.parseInt(value.substring(6,8));
					Integer.parseInt(value.substring(9));
					
					if(hh > 23) return false;
					if(mm > 60) return false;
					if(ss > 60) return false;
					
					return true;
				}
				catch(Exception ex)
				{
					return false;
				}
			}
			
			public String validate(String value) 
			{
				if(value == null || value.trim().length() == 0) return null;
				value = value.trim();
				if(value.equalsIgnoreCase("BOS") || value.equalsIgnoreCase("EOS")) return value;

				// Parse to validate format
				if(!validateTime(value)) throw new ValueFormatException("Failed to convert value(" + value + ")");
				
				return value;
				
			}
			
			@Override
			public String getStringValue(String value) {
				return validate(value);
			}

			@Override
			public String getTypedValue(String value) throws ValueFormatException {
				return validate(value);
			}
		};
		
		DataTypeWidget<String> widget = new TypedTextBoxWidget<String>(converter);
		
		if(!configuration.isReadOnly()) {		
			widget.setToolTip("Please enter a time code in HH:MM:SS:FF format");
			widget.setErrorToolTip("Invalid time code value, please enter a time code in HH:MM:SS:FF format");
		}
		else {
			widget.setReadOnly(true);
		}
		return widget;
	}
	
	@Override
	public void visit(UIStringFieldDefinition definition) {
		boolean isVodPlaylistField = definition.getXPath().equals(VOD_PLAYLIST_FIELD_NAME);
		//boolean isPositionField = definition.getXPath().equals(POSITION_FIELD_NAME);

		if (isVodPlaylistField) {
			buildVodPlaylistWidget(definition);
			return;
		}

		definition.setPositionField(false);

		/* Build the widget */
		UIStringField field = getSimpleField(definition, this.field, UIStringField.class);

		StringWidgetConfiguration configuration = new StringWidgetConfiguration(definition);
		configuration.sortOptions();

		// Read only flag
		boolean fieldReadOnly = readOnly;
		if(!readOnly && definition.isLocked()) fieldReadOnly = true;
		configuration.setReadOnly(fieldReadOnly);

		DataTypeWidget<String> typedWidget = factory.createStringWidget(configuration);
		this.initializeWidgetValue(typedWidget, field);

		StringFieldWidget widget = new StringFieldWidget(definition, field, typedWidget);
		widget.setReadOnly(fieldReadOnly);

		builtWidget = widget;
	}

	/**
	 * Builds VOD Playlist widget
	 * @param definition
	 */
	private void buildVodPlaylistWidget(UIStringFieldDefinition definition) {
		final UIStringField field = getSimpleField(definition, this.field, UIStringField.class);

		// Configuration
		final StringWidgetConfiguration configuration = new StringWidgetConfiguration(definition);
		if( !configuration.hasOptions() ) {
			configuration.setOptions( new ArrayList<UIValueOption>() );
		}
		configuration.getOptions().add(new UIValueOption("", null));
		configuration.setAnyValueAllowed(false);

		DataTypeWidget<String> typedWidget = factory.createStringWidget(configuration);
		this.initializeWidgetValue(typedWidget, field);

		final StringFieldWidget widget = new StringFieldWidget(definition, field, typedWidget);
		widget.setReadOnly(readOnly);

		builtWidget = widget;

		// Get lookup keys for all assets from lookup key manager
		VodPlaylistService.getTitlelistsOfType( "VodPlaylist", field.getValue(), new NeptuneAsyncCallback<Map<Long, String>>() {

			@Override
			public void onNeptuneFailure( Throwable caught ) {
				// TODO print an error
				// nothing to be done, the listbox will be empty
			}

			@Override
			public void onNeptuneSuccess( Map<Long, String> result ) {
				TypedListBoxWidget<String> listBox = (TypedListBoxWidget<String>) widget.getDataTypeWidget();
				listBox.clear();
				listBox.addItem("", null);
				// Add the 'Options' to the listBox
				if( field.getValue() != null )
					listBox.addItem("", null);
				for ( Long key : result.keySet() ) {
					configuration.getOptions().add( new UIValueOption( key.toString(), result.get(key) ) );
					listBox.addItem( result.get(key), key.toString() );
				}
				listBox.setValue( field.getValue() );
			}
		} );
	}

	/*
	 * Validate that the field is of the expected class
	 */
	@SuppressWarnings("unchecked")
	protected <FieldType extends UIField> FieldType getSimpleField(UIFieldDefinition definition,
	        UIField field, Class<FieldType> expectedType) {
		if (!(field.getClass().equals(expectedType))) {
			builtWidget = null;
			String name = definition.getName();
			throw new MetadataTypeMismatchException(name, definition, field);
		}

		return (FieldType) field;
	}

	/*
	 * Set the initial value of the file metadata widget
	 */
	protected <DataType, FieldType extends UISimpleField<DataType>> void initializeWidgetValue(
	        DataTypeWidget<DataType> widget, FieldType simpleField) {
		/* Set the initial widget value */
		if (simpleField.getValue() != null) {
			DataType value = simpleField.getValue();
			widget.setValue(value);
		} else if (simpleField.getStringValue() != null) {
			widget.setTextValue(simpleField.getStringValue());
		} else {
			widget.setValue(null);
		}
	}
}
