/*
 * Created on Jul 28, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex;

import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;

/**
 * @author Vijay Silva
 */
public class MetadataFieldWidget extends ComplexFieldWidget {

	/**
	 * @param assetDefinition The asset definition
	 * @param readOnly flag for read only widget
	 */
	public MetadataFieldWidget(UIAssetDefinition assetDefinition, boolean readOnly) {
		super(assetDefinition.getRootFieldDefinition(), readOnly);
		addStyleDependentName("metadata");
	}

	/**
	 * @param assetDefinition The asset definition
	 * @param readOnly flag for read only widget
	 */
	public MetadataFieldWidget(UIAssetDefinition assetDefinition, boolean readOnly, boolean isBatch) {
		super(assetDefinition.getRootFieldDefinition(), readOnly, isBatch);
		addStyleDependentName("metadata");
	}

	/*
	 * Use a different constant for the field header
	 */
	@Override
	protected String getFieldDisplayName() {
		return getViewMessages().metadataSectionHeading();
	}
}
