/*
 * Created on Jul 2, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex.table;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.MetadataWidgetBuilder;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.BooleanFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.DateFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.FloatFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.IntegerFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.SimpleFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.StringFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.TimeFieldWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;

/**
 * Builder that creates the widgets to use in the complex field table
 * 
 * @author Vijay Silva
 */
class ComplexTableMetadataWidgetBuilder extends MetadataWidgetBuilder {

	/* The factory to build widgets */
	private final ComplexFieldTable fieldView;

	/* The context state required by the visitor */
	private UIComplexField complexField;

	/* Style Names */
	private static final String STYLE_VIEW_SUFFIX = "complexTable";
	private static final String STYLE_TYPE_SUFFIX = "complexTable-";

	/**
	 * Constructor
	 * 
	 * @param fieldView The complex field table view
	 */
	public ComplexTableMetadataWidgetBuilder(ComplexFieldTable fieldView) {
		this.fieldView = fieldView;
	}

	/**
	 * Build the widget for the given field definition
	 * 
	 * @param field The Complex Field that represents a row in the table
	 */
	public SimpleFieldWidget<?, ?, ?> build(UIComplexField parentField, UISimpleFieldDefinition fieldDefinition, 
			UIField field, boolean readOnly) 
	{
		this.complexField = parentField;
		return this.build(fieldDefinition, field, readOnly);
	}

	/*
	 * Get the built widget
	 */
	protected SimpleFieldWidget<?, ?, ?> getBuiltWidget() {
		this.complexField = null;
		return super.getBuiltWidget();
	}

	@Override
	public void visit(UIBooleanFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			BooleanFieldWidget widget = (BooleanFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<Boolean>(fieldView,
			        complexField, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UIIntegerFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			IntegerFieldWidget widget = (IntegerFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<Long>(fieldView,
			        complexField, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UIFloatFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			FloatFieldWidget widget = (FloatFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(fieldView,
			        complexField, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UIDateFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			DateFieldWidget widget = (DateFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(fieldView,
			        complexField, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UITimeFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			TimeFieldWidget widget = (TimeFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(fieldView,
			        complexField, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UIStringFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			StringFieldWidget widget = (StringFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(fieldView,
			        complexField, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	// ========================================================================
	// ===================== VALUE CHANGE HANDLER
	// ========================================================================

	/*
	 * Event handling class to handle the value change event fired by the simple field widget
	 */
	private static final class WidgetValueChangeHandler<DataType> implements
	        ValueChangeHandler<DataType> {

		private ComplexFieldTable view;
		private UIComplexField parentField;
		private SimpleFieldWidget<?, ?, DataType> widget;

		/**
		 * Constructor
		 */
		public WidgetValueChangeHandler(ComplexFieldTable view, UIComplexField parentField,
		        SimpleFieldWidget<?, ?, DataType> widget) {
			this.view = view;
			this.parentField = parentField;
			this.widget = widget;
		}

		@Override
		public void onValueChange(ValueChangeEvent<DataType> event) {
			/* Set the typed value, and clear the 'string' value */
			UISimpleField<DataType> simpleField = widget.getField();
			simpleField.setValue(event.getValue());
			view.handleMetadataValueChanged(parentField, widget);
		}
	}
}
