/*
 * Created on Jul 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasBlurHandlers;
import com.google.gwt.event.dom.client.HasFocusHandlers;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasValue;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;

/**
 * A Wrapper widget around the Data Type Widget which also maintains the model (simple field and
 * simple field definition)
 * 
 * @author Vijay Silva
 */
public abstract class SimpleFieldWidget<FieldDefinitionType extends UISimpleFieldDefinition, FieldType extends UISimpleField<DataType>, DataType>
        extends Composite implements HasValue<DataType>, Focusable, HasBlurHandlers,
        HasFocusHandlers {

	private FieldDefinitionType fieldDefinition;
	private FieldType field;
	private DataTypeWidget<DataType> widget;

	/**
	 * Constructor
	 */
	public SimpleFieldWidget(FieldDefinitionType fieldDefinition, FieldType field,
	        DataTypeWidget<DataType> widget) {
		this.fieldDefinition = fieldDefinition;
		this.field = field;
		this.widget = widget;

		this.initWidget(widget);
	}

	/**
	 * @return the fieldDefinition
	 */
	public FieldDefinitionType getFieldDefinition() {
		return fieldDefinition;
	}

	/**
	 * @return The field
	 */
	public FieldType getField() {
		return field;
	}

	/**
	 * @return The data type widget
	 */
	public DataTypeWidget<DataType> getDataTypeWidget() {
		return widget;
	}

	// ========================================================================
	// ===================== HAS VALUE
	// ========================================================================

	/**
	 * @see DataTypeWidget#getValue()
	 */
	@Override
	public DataType getValue() {
		return widget.getValue();
	}

	/**
	 * @see DataTypeWidget#setValue(Object)
	 */
	@Override
	public void setValue(DataType value) {
		widget.setValue(value);
	}

	/**
	 * @see DataTypeWidget#setValue(Object, boolean)
	 */
	@Override
	public void setValue(DataType value, boolean fireEvents) {
		widget.setValue(value, fireEvents);
	}

	/**
	 * @see DataTypeWidget#addValueChangeHandler(ValueChangeHandler)
	 */
	@Override
	public HandlerRegistration addValueChangeHandler(ValueChangeHandler<DataType> handler) {
		return widget.addValueChangeHandler(handler);
	}

	// ========================================================================
	// ===================== FOCUSABLE
	// ========================================================================

	/**
	 * @see DataTypeWidget#getTabIndex()
	 */
	@Override
	public int getTabIndex() {
		return widget.getTabIndex();
	}

	/**
	 * @see DataTypeWidget#setTabIndex(int)
	 */
	@Override
	public void setTabIndex(int index) {
		widget.setTabIndex(index);
	}

	/**
	 * @see DataTypeWidget#setAccessKey(char)
	 */
	@Override
	public void setAccessKey(char key) {
		widget.setAccessKey(key);
	}

	/**
	 * @see DataTypeWidget#setFocus(boolean)
	 */
	@Override
	public void setFocus(boolean focused) {
		widget.setFocus(focused);
	}

	// ========================================================================
	// ===================== FOCUS HANDLERS
	// ========================================================================

	/**
	 * @see DataTypeWidget#addFocusHandler(FocusHandler)
	 */
	@Override
	public HandlerRegistration addFocusHandler(FocusHandler handler) {
		return this.addDomHandler(handler, FocusEvent.getType());
	}

	/**
	 * @see DataTypeWidget#addBlurHandler(BlurHandler)
	 */
	@Override
	public HandlerRegistration addBlurHandler(BlurHandler handler) {
		return this.addDomHandler(handler, BlurEvent.getType());
	}

	// ========================================================================
	// ===================== DATA TYPE WIDGET METHODS
	// ========================================================================

	/**
	 * @see DataTypeWidget#isValidValue()
	 */
	public boolean isValidValue(boolean draft) 
	{
		clearValidationError();

		boolean valid = widget.isValidValue();
		if(!valid) return false;

		if(!draft && fieldDefinition.isRequired())
		{
			String text = widget.getTextValue();
			if (text == null || text.trim().isEmpty()) 
			{
				String tooltip = "Value is required."; // Get from bundle
				showValidationError(tooltip);
				return false;
			}
		}
		
		return true;
	}

	/**
	 * @see DataTypeWidget#getTextValue()
	 */
	public String getTextValue() {
		return widget.getTextValue();
	}

	/**
	 * @see DataTypeWidget#setTextValue(String)
	 */
	public void setTextValue(String textValue) {
		widget.setTextValue(textValue);
	}

	/**
	 * @see DataTypeWidget#showValidationError(String)
	 */
	public void showValidationError(String toolTip) {
		widget.showValidationError(toolTip);
	}

	/**
	 * @see DataTypeWidget#clearValidationError()
	 */
	public void clearValidationError() {
		widget.clearValidationError();
	}

	/**
	 * @see DataTypeWidget#hasValidationError()
	 */
	public boolean hasValidationError() {
		return widget.hasValidationError();
	}

	/**
	 * @see DataTypeWidget#isReadOnly()
	 */
	public boolean isReadOnly() {
		return widget.isReadOnly();
	}

	/**
	 * @see DataTypeWidget#setReadOnly(boolean)
	 */
	public void setReadOnly(boolean readOnly) {
		widget.setReadOnly(readOnly);
	}

	/**
	 * @see DataTypeWidget#isEnabled()
	 */
	public boolean isEnabled() {
		return widget.isEnabled();
	}

	/**
	 * @see DataTypeWidget#setEnabled(boolean)
	 */
	public void setEnabled(boolean enabled) {
		widget.setEnabled(enabled);
	}

	/**
	 * @see DataTypeWidget#getToolTip()
	 */
	public String getToolTip() {
		return widget.getToolTip();
	}

	/**
	 * @see DataTypeWidget#setToolTip(String)
	 */
	public void setToolTip(String toolTip) {
		widget.setToolTip(toolTip);
	}

	/**
	 * @see DataTypeWidget#getErrorToolTip()
	 */
	public String getErrorToolTip() {
		return widget.getErrorToolTip();
	}

	/**
	 * @see DataTypeWidget#setErrorToolTip(String)
	 */
	public void setErrorToolTip(String errorToolTip) {
		widget.setErrorToolTip(errorToolTip);
	}

	/**
	 * @see DataTypeWidget#getCurrentToolTip()
	 */
	public String getCurrentToolTip() {
		return widget.getCurrentToolTip();
	}
}
