/*
 * Created on Jul 2, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.table;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.MetadataWidgetBuilder;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.BooleanFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.DateFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.FloatFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.IntegerFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.SimpleFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.StringFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.TimeFieldWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;

/**
 * Builder that creates the widgets for a simple field
 * 
 * @author Vijay Silva
 */
class SimpleViewMetadataWidgetBuilder extends MetadataWidgetBuilder {

	/* Properties */
	private final SimpleFieldGroup fieldView;

	/* Style Names */
	private static final String STYLE_VIEW_SUFFIX = "simpleFieldView";
	private static final String STYLE_TYPE_SUFFIX = "simpleFieldView-";

	/**
	 * Constructor
	 */
	public SimpleViewMetadataWidgetBuilder(SimpleFieldGroup fieldGroup) {
		super();

		this.fieldView = fieldGroup;
	}

	@Override
	public SimpleFieldWidget<?, ?, ?> build(UISimpleFieldDefinition fieldDefinition, UIField field, boolean readOnly) 
	{
		return super.build(fieldDefinition, field, readOnly);
	}

	@Override
	public void visit(UIBooleanFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			BooleanFieldWidget widget = (BooleanFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<Boolean>(fieldView, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UIIntegerFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			IntegerFieldWidget widget = (IntegerFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<Long>(fieldView, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UIFloatFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			FloatFieldWidget widget = (FloatFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(fieldView, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UIDateFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			DateFieldWidget widget = (DateFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(fieldView, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UITimeFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			TimeFieldWidget widget = (TimeFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(fieldView, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	@Override
	public void visit(UIStringFieldDefinition definition) {
		super.visit(definition);

		if (!readOnly) {
			StringFieldWidget widget = (StringFieldWidget) ((Object) builtWidget);
			widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(fieldView, widget));
		}

		builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
		builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
	}

	// ========================================================================
	// ===================== VALUE CHANGE HANDLER
	// ========================================================================

	/*
	 * Event handling class to handle the value change event fired by the simple field widget
	 */
	private static final class WidgetValueChangeHandler<DataType> implements
	        ValueChangeHandler<DataType> {

		private SimpleFieldGroup view;
		private SimpleFieldWidget<?, ?, DataType> widget;

		/**
		 * Constructor
		 */
		public WidgetValueChangeHandler(SimpleFieldGroup view,
		        SimpleFieldWidget<?, ?, DataType> widget) {
			this.view = view;
			this.widget = widget;
		}

		@Override
		public void onValueChange(ValueChangeEvent<DataType> event) {
			/* Set the typed value, and clear the 'string' value */
			UISimpleField<DataType> simpleField = widget.getField();
			simpleField.setValue(event.getValue());
			view.handleMetadataValueChanged(simpleField, widget);
		}
	}
}
