/*
 * Created on Jul 2, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DataTypeWidgetMessages;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DefaultDataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedSuggestBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;

/**
 * DataTypeWidget factory for the File View metadata widgets
 * 
 * @author Vijay Silva
 */
public class FileDataTypeWidgetFactory extends DefaultDataTypeWidgetFactory {

	/* The messages */
	private TitleViewMessages messages = GWT.create(TitleViewMessages.class);
	private DataTypeWidgetMessages dtMessages = GWT.create(DataTypeWidgetMessages.class);

	private UIAssetFile file;

	@Override
	public DataTypeWidget<String> createStringWidget(StringWidgetConfiguration configuration) {
		// File URI Widget (suggest box)
		if (configuration instanceof FileURIWidgetConfiguration) {
			return createFileURIWidget((FileURIWidgetConfiguration)configuration);
		} 
		// Lookup Key Widget (dropdown)
		else if(configuration instanceof LookupKeyWidgetConfiguration) {
			return createLookupKeyWidget((LookupKeyWidgetConfiguration)configuration);
		} 
		// Default String Widget
		else {
			return super.createStringWidget(configuration);
		}
	}

	/**
	 * Creates File URI widget (suggest box)
	 * @param fileConfiguration
	 * @return
	 */
	private DataTypeWidget<String> createFileURIWidget(FileURIWidgetConfiguration fileConfiguration) {
		/* Build the oracle for suggestions */
		FileURIOracle oracle = new FileURIOracle(file);
		if (fileConfiguration.getFilePaths() != null) {
			oracle.addAll(fileConfiguration.getFilePaths());
		}

		TypedSuggestBoxWidget<String> widget = new TypedSuggestBoxWidget<String>(
		        new FileURIConverter(), oracle);
		widget.setToolTip(messages.fileURIWidgetToolTip());
		widget.setErrorToolTip(messages.fileURIWidgetErrorToolTip());

		return widget;
	}
	
	/**
	 * Creates Lookup Key widget: dropdown if there are any options 
	 * or a text box otherwise  
	 * @param configuration
	 * @return
	 */
	private DataTypeWidget<String> createLookupKeyWidget(LookupKeyWidgetConfiguration configuration) {
	    
	        // Due to the asynchronous nature of the database operation necessary to retrieve the lookup keys,
	        // the configuration options will not be used here. The listbox items should be filled inside the 
	        // database operation callback called after the call for this method
	    
		IValueConverter<String> converter = new StringConverter();
		DataTypeWidget<String> widget = null;

                TypedListBoxWidget<String> listBox = new TypedListBoxWidget<String>(converter);
                
                /* The default item */
                listBox.addItem("", null);

                widget = listBox;

		widget.setToolTip(dtMessages.stringWidgetToolTip());
		widget.setErrorToolTip(dtMessages.stringWidgetErrorToolTip());
		
		return widget;
	}
	
	/**
	 * @return the file
	 */
	public UIAssetFile getFile() {
		return file;
	}

	/**
	 * @param file the file to set
	 */
	public void setFile(UIAssetFile file) {
		this.file = file;
	}
}
