/*
 * Created on Jul 10, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * Converter for validation of File URI paths
 * 
 * @author Vijay Silva
 */
public class FileURIConverter implements IValueConverter<String> {

	@Override
	public String getStringValue(String typedValue) {
		return typedValue;
	}

	@Override
	public String getTypedValue(String value) throws ValueFormatException {
		if (value != null) {
			value = value.trim();
		}

		if (!isValidFileURI(value)) {
			throw new ValueFormatException(value + " is not a valid File URI.");
		}

		return value;
	}

	/*
	 * Validate the File URI
	 */
	private boolean isValidFileURI(String value) {
		return true;
	}
}
