/*
 * Created on Jul 10, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.google.gwt.user.client.ui.SuggestOracle;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;

/**
 * The Suggestion Oracle for the File URI Widget
 * 
 * @author Vijay Silva
 */
public class FileURIOracle extends SuggestOracle {

	/* Properties */
	private List<FileURISuggestion> suggestions = new ArrayList<FileURISuggestion>();
	
	private UIAssetFile file;

	public FileURIOracle() {
	}
	
	/**
	 * Constructor
	 */
	public FileURIOracle(UIAssetFile file) {
		this.file = file;
	}

	// ========================================================================
	// ===================== THE SUGGESTION
	// ========================================================================

	/**
	 * The File URI Suggestion
	 */
	private class FileURISuggestion implements Suggestion {

		/* The file path */
		private UIAssetFilePath filePath;

		/**
		 * Build a File URI Suggestion
		 */
		public FileURISuggestion(UIAssetFilePath filePath) {
			this.filePath = filePath;
		}

		@Override
		public String getDisplayString() {
			return filePath.getFilePath();
		}

		@Override
		public String getReplacementString() {
			return filePath.getFilePath();
		}

		/**
		 * Get the file path for this suggestion
		 * 
		 * @return The file path
		 */
		public UIAssetFilePath getFilePath() {
			return this.filePath;
		}
	}

	// ========================================================================
	// ===================== GETTING SUGGESTIONS
	// ========================================================================

	/**
	 * Add a new suggestion
	 * 
	 * @param filePath The File Path to provide as a suggestion
	 */
	public void add(UIAssetFilePath filePath) {
		FileURISuggestion suggestion = new FileURISuggestion(filePath);
		this.suggestions.add(suggestion);
	}

	/**
	 * Add all the file paths as suggestions
	 * 
	 * @param filePaths The collection of file paths
	 */
	public void addAll(Collection<UIAssetFilePath> filePaths) {
		for (UIAssetFilePath filePath : filePaths) {
			add(filePath);
		}
	}

	/**
	 * Remove all suggestions
	 */
	public void clear() {
		this.suggestions.clear();
	}

	/**
	 * Get the suggestions to use for the given request
	 * 
	 * @see SuggestOracle#requestSuggestions(Request, Callback)
	 */
	@Override
	public void requestSuggestions(Request request, Callback callback) {
		List<FileURISuggestion> filteredSuggestions = getFilteredSuggestions(request);
		Response response = new Response(filteredSuggestions);
		callback.onSuggestionsReady(request, response);
	}

	/*
	 * Get the list of suggestions filtered by the
	 */
	private List<FileURISuggestion> getFilteredSuggestions(Request request) {
		List<FileURISuggestion> result = new ArrayList<FileURISuggestion>();
		int size = 0;

		/* Check if the filter is present and skip if not present */
		String query = request.getQuery();
		if (query == null || query.trim().length() == 0)
			return result;

		/* search for matching suggestions */
		query = query.trim().toLowerCase();
		int limit = request.getLimit();
		
		String filterFieldValue = getFilterFieldValue();
		
		for (FileURISuggestion suggestion : this.suggestions) {
			String filterValue = null;
			String path = suggestion.getFilePath().getFilePath();
			String fileSeparator = path.contains("/") ? "/" : "\\";
			if(filterFieldValue != null && filterFieldValue.trim().length() > 0) {
				filterValue = fileSeparator + filterFieldValue + fileSeparator;
			}
			boolean filterValid = filterValue == null ? true : path.contains(filterValue);
			if (filterValid && path != null && path.toLowerCase().contains(query)) {
				result.add(suggestion);
				size++;
				if (limit > 0 && limit <= size)
					break;
			}
		}

		return result;
	}
	
	/**
	 * Reads the provider Id from the package asset type. 
	 * TODO: Do this in a generic way. 
	 *  
	 * @return
	 */
	private String getFilterFieldValue() {
		UIField providerInfoField = this.file.getParentAsset().getRootAsset()
				.getRootField().getChildren().getField("ProviderInfo");
		if (providerInfoField != null) {
			UIField identifierField = ((UIComplexField) providerInfoField)
					.getChildren().getField("Identifier");
			if (identifierField != null) {
				UIField idField = ((UIComplexField) identifierField)
						.getChildren().getField("Id");
				if (idField != null && idField instanceof UIStringField) {
					return ((UIStringField) idField).getValue();
				} else {
					return null;
				}
			} else {
				return null;
			}
		} else {
			return null;
		}
	}
}
