package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.Window.Location;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * This dialog contains the SFTP applet for uploading file assets
 * 
 * @author bng
 */
public class FileUploadDialog extends DialogBox {
	private FileView parentView;
	private String uploadPath;
	private ButtonWidget closeButton;	
	final static String MAX_NUM_FILES = "1";  //restrict to one file at a time 
	static FileUploadDialog instance;

    static {
    	exportCallbackMethods();
    }
	
    public static native void exportCallbackMethods() /*-{       
		$wnd.JSTransferCancelled = @com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileUploadDialog::onTransferCanceled();    
		$wnd.JSTransferFailed = @com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileUploadDialog::onTransferFailed(Ljava/lang/String;);    
		$wnd.JSTransferDone = @com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileUploadDialog::onTransferDone(Ljava/lang/String;);    
		$wnd.JSAppletInitialized = @com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileUploadDialog::onAppletInitialized(Ljava/lang/String;);    
		$wnd.JSTransferTriggered = @com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileUploadDialog::onTransferTriggered(Ljava/lang/String;);    
		$wnd.JSTransferStarted = @com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileUploadDialog::onTransferStarted(Ljava/lang/String;Ljava/lang/String;);    
		$wnd.JSTransferCompleted = @com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileUploadDialog::onTransferCompleted(Ljava/lang/String;);    
	}-*/;	   
	
	public static void onTransferDone(String fileNamesStr) { 
		//If there are more than one files, there will be a "|" separated string, 
		//String uploadedFiles[]=null;
		//uploadedFiles = fileNamesStr.split("\\|");
		//However we are restricting the upload to only one file:
		String fileName = fileNamesStr.trim(); //only one file
		instance.handleFileUploadSuccessful(fileName);
		instance.hide();
    } 
	
	public static void onTransferCanceled() { 
		instance.enableCloseButton();
    } 

	public static void onTransferFailed(String errorMsg) { 
		instance.enableCloseButton();
    } 
	
	//These 4 callbacks are defined to avoid "undefined functions" log messages in browser console
	public static void onAppletInitialized(String versionStr) { 
	}	

	public static void onTransferTriggered(String fileNamesStr) { 
	}	

	public static void onTransferStarted(String fileName, String fileSize) {
		instance.disableCloseButton();
	}	

	public static void onTransferCompleted(String fileName) { 
	}	
	
	public FileUploadDialog(FileView parent, Map<String,String> regParameters, Map<String,String> xtraParameters){
		setText("File Upload");

		DockPanel dock = new DockPanel();
	    dock.setSpacing(4);
		
		regParameters.put(FileUploadWidget.REG_PARM_MAX_FILES, MAX_NUM_FILES);  //limit the # of files 
	    //Store the sftp upload path (set in the backend)
		uploadPath = xtraParameters.get(FileUploadWidget.XTRA_PARM_ACCOUNT);

		String configUrl = regParameters.get(FileUploadWidget.REG_PARM_URL);
		if (configUrl == null || configUrl.trim().isEmpty()) {
			//Get host name from url
			String hostName = Location.getHostName();
			configUrl = "sftp://" + hostName;
			regParameters.put(FileUploadWidget.REG_PARM_URL,configUrl);
		}
		
	    final FileUploadWidget applet = new FileUploadWidget(600, 250, regParameters, xtraParameters);
		parentView=parent;
		closeButton = new ButtonWidget("Close");
		closeButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		closeButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				hide();
			}
		});
	    
		dock.add(applet, DockPanel.NORTH);
		dock.add(closeButton, DockPanel.SOUTH);
		dock.setCellHorizontalAlignment(closeButton, DockPanel.ALIGN_RIGHT);		
		dock.setWidth("100%");
	    setWidget(dock);
	    instance = this;
	}

	void disableCloseButton() {
		closeButton.setEnabled(false);
	}

	void enableCloseButton() {
		closeButton.setEnabled(true);
	}
	
	void handleFileUploadSuccessful(String fileName) {
		List<String> filePaths = new ArrayList<String>();
		filePaths.add(uploadPath + "/" + fileName);
		parentView.saveUploadedFileAssets(filePaths);
	}
	
	void handleFileUploadCanceled() {
		parentView.handleFileUploadCanceled();
	}
	
	void handleFileUploadError() {
		parentView.handleFileUploadError();
	}
}
