package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import java.util.LinkedHashMap;
import java.util.Map;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;

/**
 * This is a custom GWT widget that wraps around the SFTP applet from JFileUpload
 * 
 * @author bng
 */
public class FileUploadWidget  extends Widget {
	   final static String REG_PARM_ARCHIVE = "ARCHIVE"; 
	   final static String REG_PARM_URL = "url"; 
	   final static String REG_PARM_MODE = "mode"; 
	   final static String REG_PARM_AUTHENTICATION = "authentication"; 
	   final static String REG_PARM_STARTDIR = "startdir"; //for file chooser
	   final static String REG_PARM_MAX_SIZE = "maxsize"; 
	   final static String REG_PARM_MAX_FILES = "maxfiles"; 
	   final static String REG_PARM_RESOURCES = "resources"; 
	   final static String XTRA_PARM_USERNAME = "username"; 
	   final static String XTRA_PARM_PASSWORD = "password"; 
	   final static String XTRA_PARM_FTP_PASSIVE = "pasv"; 
	   final static String XTRA_PARM_DELETEONFAIL = "deleteonfail"; 
	   final static String XTRA_PARM_ACCOUNT = "account";  //relative to ftp root folder 
	   final static String XTRA_PARM_ACCOUNTCREATION = "accountcreation";

	   final static String UPLOAD_STATUS_COMPLETED = "COMPLETED";
	   final static String UPLOAD_STATUS_CANCELLED = "CANCELLED";
	   final static String UPLOAD_STATUS_FAILED = "FAILED";
	   
	   private static int count = 0; 
	   private final static String appltPrefix = "appltDivID_"; 

	   private final String appltDivId; 
	   private int height = 250;
	   private int width = 250;
	   protected Map<String,String> regParameters = new LinkedHashMap<String,String>(); 
	   protected Map<String,String> xtraParameters = new LinkedHashMap<String,String>(); 
	  
	   
	   public FileUploadWidget(int wd, int ht, String url) {
		     width = wd;
		     height = ht;

			 if (regParameters.get(REG_PARM_URL) == null)
				 regParameters.put(REG_PARM_URL, url);

			 appltDivId = appltPrefix + count; 
		     ++count; 
			 init();
	   }

	   /**
	    *   regParameters and xtraParameters contains the parameters read from configuration file on the server
       **/	   
	   public FileUploadWidget(int wd, int ht, Map<String,String> regParameters, Map<String,String> xtraParameters) {
		     width = wd;
		     height = ht;
             this.regParameters = regParameters;
             this.xtraParameters = xtraParameters;

			 appltDivId = appltPrefix + count; 
		     ++count; 
			 init();
	   }
	   
	   /**
	    *   Initialize()
       **/	   
	   private void init () {
		     //Set all required parameters 
		     //Parameters from this two maps will be used to generate the PARAM tags later on
			 regParameters.put(REG_PARM_ARCHIVE, "jfileupload.jar,ftpimpl.jar,cnet.jar,clogging.jar,sftpimpl.jar,jsch.jar,jsapi.jar");
			 //regParameters.put("CODE", "jfileupload.upload.client.MApplet.class");
			 regParameters.put("CODE", "jfileupload.upload.client.JSMApplet.class");
			 regParameters.put("CODEBASE", "./");
			 regParameters.put("NAME", "fileupload");
			 regParameters.put("type", "application/x-java-applet;version=1.4");
			 regParameters.put("scriptable", "true");
			 regParameters.put("mayscript", "true");

		     if (regParameters.get(REG_PARM_MAX_SIZE) == null)         //limit max size of file
		    	 regParameters.put(REG_PARM_MAX_SIZE, "10737418240");  
			 if (regParameters.get(REG_PARM_MAX_FILES) == null)        //limit the max # of files 
				 regParameters.put(REG_PARM_MAX_FILES, "1");
			 if (regParameters.get(REG_PARM_RESOURCES) == null)        //name of applet customization file (mainly UI) 
				 regParameters.put(REG_PARM_RESOURCES, "sftp_i18n");
			 if (regParameters.get(REG_PARM_MODE) == null)             //for ftp or sftp 
				 regParameters.put(REG_PARM_MODE, "ftp");

				 
			 if (xtraParameters.get(XTRA_PARM_ACCOUNTCREATION) == null) //create folder if upload path do not exist    
				 xtraParameters.put(XTRA_PARM_ACCOUNTCREATION, "true");
			 if (xtraParameters.get(XTRA_PARM_FTP_PASSIVE) == null)
				 xtraParameters.put(XTRA_PARM_FTP_PASSIVE, "true");
			 if (xtraParameters.get(XTRA_PARM_DELETEONFAIL) == null)     
				 xtraParameters.put(XTRA_PARM_DELETEONFAIL, "true");
			   
			 //Create "div" element to contain applet
			 Element element = DOM.createElement("div"); 
			 DOM.setElementProperty(element, "id", appltDivId); 
			      
			 setElement(element); 		   		   
	   }
	   
	   /**
	    * Javascript: to get browser type
       **/	   
	   public static native String getUserAgent() /*-{
	   		return navigator.userAgent.toLowerCase();
	   }-*/;

	   
	   /**
	    * Javascript: to get files uploaded 
       **/	   
	   public static native String getFileNames() /*-{
  			return $doc.fileupload.getFilenames();
  	   }-*/;

	   	   
	   public static native String getState(String fileName) /*-{
  			return $doc.fileupload.getState(fileName);
	   }-*/; 
	  
	   
	   protected void onLoad() { 
		     String userName = xtraParameters.get(XTRA_PARM_USERNAME);
		     if (userName == null || userName.isEmpty())
		    	 regParameters.put(REG_PARM_AUTHENTICATION, "auto");
		     if (userName != null && userName.isEmpty())
		    	 xtraParameters.remove(XTRA_PARM_USERNAME);
		     embedApplet();
		     super.onLoad(); 
	   }
	   	   
	   protected void onUnload() { 
		     getElement().removeChild(DOM.getFirstChild(getElement())); 		   
		     super.onUnload(); 
	   } 

	   
	   protected void embedApplet() { 	   
		     getElement().setInnerHTML(buildAppletSource()); 
	   }
	   
	   protected boolean isIE(){
		   if(getUserAgent().contains("msie"))
			   return true;
		   else
			   return false;
	   }
	   
	  
	   /**
	    * Construct html source for regular parameters 
	   */	   	   
	   private void buildSourceForRegParameters(StringBuilder sb) {
		   Object keys[] = regParameters.keySet().toArray();
		   for (int i=0;i<keys.length;i++) {
			   //$doc.writeln('<PARAM NAME="scriptable" VALUE="true">');
			   sb.append("<PARAM NAME=\"");
			   sb.append(keys[i]);
			   sb.append("\" VALUE=\"");
			   sb.append(regParameters.get(keys[i]));
			   sb.append("\">\n");
		   }
	   }

	   /**
	    * Construct html source for extra parameters 
	   */	   	   	   
	   private void buildSourceForXtraParameters(StringBuilder sb) {
		   Object keys[] = xtraParameters.keySet().toArray();
		   for (int i=0;i<keys.length;i++) {
			   //document.writeln('<PARAM NAME="param1" VALUE="username">');
			   //document.writeln('<PARAM NAME="value1" VALUE="anonymous">');
			   
			   sb.append("<PARAM NAME=\"param");
			   sb.append((i+1));
			   sb.append("\" VALUE=\"");
			   sb.append(keys[i]);
			   sb.append("\">\n");

			   sb.append("<PARAM NAME=\"value");
			   sb.append((i+1));
			   sb.append("\" VALUE=\"");
			   sb.append(xtraParameters.get(keys[i]));
			   sb.append("\">\n");
		   }
	   }
	   
	   
	   /**
	    * Build html source for the applet 
	   */	   	   	   
	   private String buildAppletSource(){
		   StringBuilder sb = new StringBuilder();
		   
		   if (isIE() == true) {  
		      //sb.append("<OBJECT classid=\"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93\" WIDTH=\"250\" HEIGHT=\"250\" NAME=\"fileupload\" codebase=\"http://java.sun.com/update/1.4.2/jinstall-1_4-windows-i586.cab#Version=1,4,0,0\">\n");
			  sb.append("<OBJECT classid=\"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93\" WIDTH=\"");
			  sb.append(width);
			  sb.append("\" HEIGHT=\"");
			  sb.append(height);
			  sb.append("\" NAME=\"fileupload\" codebase=\"http://java.sun.com/update/1.4.2/jinstall-1_4-windows-i586.cab#Version=1,4,0,0\">\n");
		   }
		   else {
		   	  //sb.append("<APPLET CODE=\"jfileupload.upload.client.MApplet.class\" JAVA_CODEBASE=\"./\" ARCHIVE=\"jfileupload.jar,httpimpl.jar,chttpclient.jar,clogging.jar\" WIDTH=\"250\" HEIGHT=\"250\" NAME=\"fileupload\">\n");
		   	  //sb.append("<APPLET CODE=\"jfileupload.upload.client.MApplet.class\" JAVA_CODEBASE=\"./\" ARCHIVE=\"");
		   	  sb.append("<APPLET CODE=\"jfileupload.upload.client.JSMApplet.class\" JAVA_CODEBASE=\"./\" ARCHIVE=\"");
			  sb.append(regParameters.get(REG_PARM_ARCHIVE));
			  sb.append("\" WIDTH=\"");
		   	  sb.append(width);
			  sb.append("\" HEIGHT=\"");
			  sb.append(height);
		   	  sb.append("\" NAME=\"fileupload\">\n");
		   } 
		  
		   buildSourceForRegParameters(sb);
		   buildSourceForXtraParameters(sb);
		   
		   if (isIE() == true)   
		   	  sb.append("</OBJECT>\n");
		   else	  
		   	  sb.append("</APPLET>\n");		   	  
	   
		   	return sb.toString();
	   }

}
