/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.report.TitleCompareReportView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.report.TitleCompareXmlView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;


/**
 * The Widget for Title Compare
 * 
 * @author Vijay Silva
 */
public class TitleCompareView extends Composite 
{
	private ITitleCompareViewController controller;
	
	/* Widgets and Properties */
	private SimpleContainer mainContainer;
	
	private TitleCompareViewMessages messages;
	private TitleCompareViewInput input;

	private TitleCompareReportView diffView;
	private TitleCompareXmlView xmlView;
	private BusyIndicator busyIndicator;

	/* Styles */
	private static final String STYLE_NAME = "content-TitleCompareView";
	
	private boolean showXML = true;

	/**
	 * Constructor
	 */
	public TitleCompareView(ITitleCompareViewController controller) 
	{
		this.controller = controller;
		mainContainer = new SimpleContainer();
		initWidget(mainContainer);

		initialize();
	}

	public TitleCompareView(ITitleCompareViewController controller, boolean showXML) 
	{
		this.controller = controller;
		mainContainer = new SimpleContainer();
		initWidget(mainContainer);
		this.showXML = showXML;
		initialize();
	}
	
	public ITitleCompareViewController getController()
	{
		return controller;
	}
	
	@Override
	protected void onUnload() 
	{
		busyIndicator.hide();
		super.onUnload();
	}

	/*
	 * Initialize the widget
	 */
	private void initialize() 
	{
		/* Initialize the messages */
		messages = GWT.create(TitleCompareViewMessages.class);
		busyIndicator = new BusyIndicator();

		/* Set style */
		this.addStyleName(STYLE_NAME);

		/* Build the report widget */
		this.diffView = new TitleCompareReportView(this, controller, showXML);

		/* Build the preview widget */
		this.xmlView = new TitleCompareXmlView(this, controller, showXML);

	}

	/**
	 * @return the input
	 */
	public TitleCompareViewInput getInput() 
	{
		return input;
	}

	/**
	 * @param input the input to set
	 */
	public void setInput(TitleCompareViewInput input) 
	{
		this.input = input;
	}

	/**
	 * @return the messages
	 */
	public TitleCompareViewMessages getMessages() 
	{
		return messages;
	}

	
	private void clear() 
	{
		mainContainer.clear();
	}

	public void showBusyIndicator()
	{
		busyIndicator.center();
	}
	
	public void hideBusyIndicator()
	{
		busyIndicator.hide();		
	}
	
	
	/*
	 * Shows compare view
	 */
	public void showDiffView() 
	{
		clear();
		showBusyIndicator();

		mainContainer.setWidget(diffView);
		
		this.diffView.setSummaryLabel(getInput().header);
		this.diffView.refresh();
		diffView.updateSize();
		
		hideBusyIndicator();
	}

	
	public void showXmlView(UITitleCompareXmlData xmlData)
	{
		clear();
		showBusyIndicator();

		mainContainer.setWidget(xmlView);
		this.xmlView.setSummaryLabel(getInput().header);
		this.xmlView.showXmlView(xmlData);

		hideBusyIndicator();
	}
	
	
	/*
	 * Handle the failure compare event
	 */
	public void showErrorView(Throwable error)
	{
		String msg = getMessages().compareTitlesError(error.getLocalizedMessage());
		ErrorPanel errorPanel = new ErrorPanel(msg, controller);
		mainContainer.setWidget(errorPanel);
	}

}
