/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare;

import com.google.gwt.i18n.client.Messages;

/**
 * Constants for internationalization
 * 
 * @author Vijay Silva
 */
public interface TitleCompareViewMessages extends Messages {

	/**
	 * Table column name for for the asset type column in Asset Compare Table
	 */
	String assetTableAssetTypeColumnName();

	/**
	 * Table column name for for the file1 ID column in Asset Compare Table
	 */
	String assetTableFile1IDColumnName();

	/**
	 * Table column name for for the file2 ID column in Asset Compare Table
	 */
	String assetTableFile2IDColumnName();

	/**
	 * Table column name for for the difference column in Asset Compare Table
	 */
	String assetTableDifferenceTypeColumnName();

	/**
	 * The name of the ASSET1_NOT_DEFINED difference type
	 * 
	 * @param titleName The name of the title
	 */
	String asset1NotDefinedDifferenceType(String titleName);

	/**
	 * The name of the ASSET1_NOT_DEFINED difference type
	 * 
	 * @param titleName The name of the title
	 */
	String asset2NotDefinedDifferenceType(String titleName);

	/**
	 * The name of the ASSET1_NOT_DEFINED difference type
	 */
	String metadataDifferentDifferenceType();

	/**
	 * Table column name for the field name column in Field Compare Table
	 */
	String fieldTableFieldNameColumnName();

	/**
	 * Table column name for the field1 value column in Field Compare Table
	 */
	String fieldTableField1ValueColumnName(String titleName);

	/**
	 * Table column name for the field1 value column in Field Compare Table
	 */
	String fieldTableField2ValueColumnName(String titleName);

	/**
	 * Message indicating that there are no asset differences
	 */
	String noTitleDifferencesMessage();

	/**
	 * Message indicating that there are no asset differences
	 */
	String noAssetDifferencesMessage();

	/**
	 * Message indicating that there are no file differences
	 */
	String noFileDifferencesMessage();

	/**
	 * Message for failure during initialization
	 */
	String titleCompareTableInitializationError(String error);

	/**
	 * The separator to use when building the qualified field name
	 */
	String qualifiedFieldNameSeparator();

	/**
	 * Disclosure panel heading for the asset comparision table
	 */
	String assetCompareWidgetHeading();

	/**
	 * Disclosure panel heading for the file comparision table
	 */
	String fileCompareWidgetHeading();

	/**
	 * Disclosure panel heading for the metadata comparison
	 */
	String metadataCompareWidgetHeading();

	/**
	 * The label for the button to show the report
	 */
	String reportButtonLabel();

	/**
	 * The label for the button to show the preview
	 */
	String previewButtonLabel();

	/**
	 * The label for the cancel button
	 */
	String cancelButtonLabel();

	/**
	 * The preview label heading for the preview generated
	 */
	String previewHeadingLabel(String title);

	/**
	 * The preview error message
	 */
	String previewErrorMessage(String previewErrorMessage);
	
	/**
	 * The error message when compare fails
	 */
	String compareTitlesError(String error);
}
