/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.preview;

import java.util.List;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * The Title Compare Preview widget
 * 
 * @author Vijay Silva
 */
public class TitleCompareXmlWidget extends Composite 
{
	/* Properties */
	private TitleCompareView view;
	private SimpleContainer container;
	private ListBoxWidget<UIAssetSpecificationListItem> specificationBox;
	private SimpleContainer previewContents;
	private HorizontalContainer previewsContainer;
	private Label preview1HeadingLabel, preview2HeadingLabel;
	private SimpleContainer preview1Widget, preview2Widget;
	private FrameWidget previewFrame1, previewFrame2;
	
	private BusyIndicator busyIndicator;

	private Command resizeCommand;
	private HandlerRegistration windowRegistration = null;

	/* Style Names */
	private static final String STYLE_NAME = "content-TitleComparePreviewWidget";
	private static final String STYLE_SPECIFICATION_BOX = "content-TitleComparePreviewWidget-specificationsBox";
	private static final String STYLE_PREVIEWS_SECTION = "content-TitleComparePreviewWidget-previews";
	private static final String STYLE_PREVIEW_PANEL = "content-TitleComparePreviewWidget-previewPanel";
	private static final String STYLE_PREVIEW_HEADING_LABEL = "content-TitleComparePreviewWidget-previewLabel";
	private static final String STYLE_PREVIEW_WIDGET = "content-TitleComparePreviewWidget-previewWidget";
	private static final String STYLE_PREVIEW_CONTENTS = "content-TitleComparePreviewWidget-previewFrame";

	/**
	 * Constructor
	 * 
	 * @param widget The parent view
	 */
	public TitleCompareXmlWidget(TitleCompareView widget) {
		this.view = widget;
		container = new SimpleContainer();
		initWidget(container);

		initialize();
	}

	// ========================================================================
	// ===================== INITIALIZATION
	// ========================================================================

	/*
	 * Initialize the widget
	 */
	private void initialize() 
	{
		addStyleName(STYLE_NAME);

		/* Build the busy indicator */
		busyIndicator = new BusyIndicator();

		/* build the contents panel */
		DockPanel contents = new DockPanel();
		container.setWidget(contents);

		// Build drop-down box for specifications
		specificationBox = new ListBoxWidget<UIAssetSpecificationListItem>();
		specificationBox.addStyleName(STYLE_SPECIFICATION_BOX);
		specificationBox.addChangeHandler(new ChangeHandler() 
		{
			@Override
			public void onChange(ChangeEvent event) 
			{
				handleSpecificationChange();
			}
		});
		contents.add(specificationBox, DockPanel.NORTH);
		
		/* Build panel for the preview frames */
		previewContents = new SimpleContainer();
		previewContents.addStyleName(STYLE_PREVIEWS_SECTION);
		contents.add(previewContents, DockPanel.CENTER);
		previewsContainer = new HorizontalContainer();
		previewContents.setWidget(previewsContainer);

		/* Build contents for the split panel - preview panel 1 */
		preview1HeadingLabel = buildPreviewHeadingLabel();
		preview1Widget = buildPreviewWidget();
		previewsContainer.add(buildPreviewContainer(preview1HeadingLabel, preview1Widget));

		/* Build contents for the split panel - preview panel 2 */
		preview2HeadingLabel = buildPreviewHeadingLabel();
		preview2Widget = buildPreviewWidget();
		previewsContainer.add(buildPreviewContainer(preview2HeadingLabel, preview2Widget));
		
		resizeCommand = new Command() 
		{
			@Override
			public void execute() 
			{
				resizeFrame();
			}
		};

	}

	/*
	 * Build the preview container
	 */
	private Widget buildPreviewContainer(Label previewLabel, Widget previewWidget) {
		VerticalPanel previewPanel = new VerticalPanel();
		previewPanel.addStyleName(STYLE_PREVIEW_PANEL);
		previewPanel.add(previewLabel);
		previewPanel.add(previewWidget);

		return previewPanel;
	}

	/*
	 * Build the preview heading label
	 */
	private Label buildPreviewHeadingLabel() {
		Label label = new Label();
		label.addStyleName(STYLE_PREVIEW_HEADING_LABEL);
		return label;
	}

	/*
	 * Build the preview frame
	 */
	private SimpleContainer buildPreviewWidget() {
		SimpleContainer panel = new SimpleContainer();
		panel.addStyleName(STYLE_PREVIEW_WIDGET);
		return panel;
	}

	/*
	 * Get the view input
	 */
	private TitleCompareViewInput getInput() 
	{
		return view.getInput();
	}

	/*
	 * Get the view messages
	 */
	private TitleCompareViewMessages getMessages() {
		return view.getMessages();
	}


	// ========================================================================
	// ===================== WIDGET REFRESH / CONTENT GENERATION
	// ========================================================================

	/*
	 * Add the specifications, and select appropriate default
	 */
	private void updateSpecifications()
	{
		specificationBox.clear();
		
		if(getInput().compareData == null) return;
		
		List<UIAssetSpecificationListItem> specs = getInput().compareData.getSpecifications();
		if(specs == null) return; 
		
		String selectedSpecificationName = getInput().specName;
		UIAssetSpecificationListItem selectedSpec = (specs.size() == 0) ? null : specs.get(0);
	
		for(UIAssetSpecificationListItem spec : specs) 
		{
			specificationBox.addItem(spec.getDisplayName(), spec);
			if(spec.getName().equals(selectedSpecificationName)) 
			{
				selectedSpec = spec;
			}
		}

		/* Set the selected specification */
		if(selectedSpec != null) 
		{
			specificationBox.setSelectedItem(selectedSpec);
		}
	}


	// ========================================================================
	// ===================== WIDGET OVERRIDE
	// ========================================================================

	@Override
	protected void onLoad() {
		super.onLoad();
		
		// Resize handler
		windowRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateFrameSize();
			}
		});
	};

	@Override
	protected void onUnload() {
		// Remove resize handler
		windowRegistration.removeHandler();
		windowRegistration = null;
		// Hide busy indicator when widget is removed from screen
		busyIndicator.hide();

		super.onUnload();
	}

	// ========================================================================
	// ===================== EVENT HANDLING
	// ========================================================================

	/*
	 * Handle change in selected specification
	 */
	private void handleSpecificationChange() 
	{
		UIAssetSpecificationListItem specification = specificationBox.getSelectedItem();
		String name = (specification != null) ? specification.getName() : null;
		view.getController().onSpecChanged(name);
	}

	/*
	 * Handle the preview success
	 */
	public void showXmlView(UITitleCompareXmlData preview) 
	{
		preview1Widget.clear();
		preview2Widget.clear();

		updateSpecifications();
		
		/* Build the previews */
		previewFrame1 = buildPreviewFrame(preview1Widget, preview.preview1URL);
		previewFrame2 = buildPreviewFrame(preview2Widget, preview.preview2URL);

		String name = getInput().displayName1;
		preview1HeadingLabel.setText(getMessages().previewHeadingLabel(name));
		name = getInput().displayName2;
		preview2HeadingLabel.setText(getMessages().previewHeadingLabel(name));
		
		/* Update the frame size */
		updateFrameSize();
		previewContents.setWidget(previewsContainer);
		
		/* Hide busy indicator */
		busyIndicator.hide();
	}

	/*
	 * Build the preview frame, and place frame in result container
	 */
	private FrameWidget buildPreviewFrame(SimpleContainer previewResultContainer, String url) 
	{
		FrameWidget frame = new FrameWidget(url);
		frame.addStyleName(STYLE_PREVIEW_CONTENTS);
		previewResultContainer.setWidget(frame);
		return frame;
	}

	
	/*
	 * Update the size of the asset container widget
	 */
	private void updateFrameSize() {
		DeferredCommand.addCommand(resizeCommand);
	}

	/*
	 * Resize the scroll container
	 */
	private void resizeFrame() 
	{
		if (previewFrame1 == null || previewFrame2 == null) 
		{
			return;
		}

		/* Calculate the size to use */
		int width = Window.getClientWidth() - getInput().restrictedWidth;
		int height = Window.getClientHeight() - getInput().restrictedHeight - specificationBox.getOffsetHeight() - 60;
		
		/* Set the dimensions */
		previewFrame1.setPixelSize(width/2 - 10, height);
		previewFrame2.setPixelSize(width/2 - 10, height);
	}

}
