/*
 * Created on Apr 27, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.report;

import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareRecordClickEvent;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareRecordClickHandler;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTable;

/**
 * The Asset Compare Widget showing the asset differences
 * 
 * @author Vijay Silva
 */
class AssetCompareWidget extends TitleCompareReportSection 
{
	/* Properties / Widgets */
	private AssetCompareTable compareTable;

	/* Style Names */
	private static final String STYLE_NAME = "content-AssetCompareWidget";

	/**
	 * Constructor
	 */
	public AssetCompareWidget(TitleCompareReportView reportWidget) {
		super(reportWidget);
		initialize();
	}

	/*
	 * Initialize the widget
	 */
	private void initialize() {
		/* The style */
		this.addStyleName(STYLE_NAME);

		/* Build the asset compare table to render */
		compareTable = buildCompareTable();
		compareTable.addRecordClickHandler(new AssetCompareRecordClickHandler() {
			@Override
			public void onRecordClicked(AssetCompareRecordClickEvent event) {
				handleRecordClicked(event);
			}
		});
		getContainer().setContent(compareTable);
	}

	/*
	 * Build the compare table
	 */
	protected AssetCompareTable buildCompareTable() 
	{
		return new AssetCompareTable(getMessages(), false);
	}

	/*
	 * Get the section heading
	 */
	@Override
	protected String getSectionHeading() {
		return getMessages().assetCompareWidgetHeading();
	}

	/**
	 * Refresh the display of this widget
	 */
	public void refresh() 
	{
		compareTable.setInput(getInput());
		compareTable.refresh();
	}

	/*
	 * Get the table
	 */
	AssetCompareTable getTable() {
		return this.compareTable;
	}

	/*
	 * Handle the record click event
	 */
	private void handleRecordClicked(AssetCompareRecordClickEvent event) {
		getReportWidget().getMetadataCompareWidget().showWidgetForRecord(event.getRecord());
	}
}
