/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.report;

import java.util.List;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifference;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareRecord;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTable;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTableColumn;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.field.FieldCompareTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FocusContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Widget for showing the metadata differences for a particular asset
 * 
 * @author Vijay Silva
 */
class AssetMetadataCompareWidget extends Composite implements Focusable {

	/* Widgets / Properties */
	private final MetadataCompareWidget metadataCompareWidget;
	private final FocusContainer container;
	private final UIAssetDifference difference;

	/* The Style Names */
	private static final String STYLE_NAME = "content-AssetMetadataCompareWidget";
	private static final String STYLE_ASSET_TABLE = "content-AssetMetadataCompareWidget-assetDescriptionTable";
	private static final String STYLE_ASSET_TABLE_WIDGET = "content-AssetMetadataCompareWidget-assetTable";
	private static final String STYLE_ASSET_TABLE_HEADING = "content-AssetMetadataCompareWidget-assetTableHeading";
	private static final String STYLE_ASSET_TABLE_VALUE = "content-AssetMetadataCompareWidget-assetTableValue";

	/* The maximum number of cells in the asset description table row, must be a multiple of 2 */
	private static final int ASSET_TABLE_CELL_LIMIT = 6;

	/**
	 * Constructor
	 */
	public AssetMetadataCompareWidget(MetadataCompareWidget parent, UIAssetDifference difference) {
		this.metadataCompareWidget = parent;
		this.difference = difference;
		container = new FocusContainer();
		initWidget(container);

		initialize();
	}

	/*
	 * Initialize the widget
	 */
	private void initialize() {
		addStyleName(STYLE_NAME);

		/* Set the contents of this container */
		VerticalContainer contents = new VerticalContainer();
		container.setWidget(contents);

		/* Build a description table for the asset */
		Widget descriptionWidget = buildAssetDescriptionWidget();
		contents.add(descriptionWidget);

		/* Build the field comparison table */
		FieldCompareTable table = new FieldCompareTable(getMessages(), getInput(), getDifference());
		contents.add(table);
		table.refresh();
	}

	/**
	 * Get the view input
	 * 
	 * @return The view input
	 */
	public TitleCompareViewInput getInput() 
	{
		return metadataCompareWidget.getInput();
	}

	/**
	 * Get the asset difference
	 * 
	 * @return The asset difference input
	 */
	public UIAssetDifference getDifference() {
		return difference;
	}

	// ========================================================================
	// ===================== INITIALIZATION
	// ========================================================================

	/*
	 * Build a description widget for the asset for which fields are compared
	 */
	private Widget buildAssetDescriptionWidget() {
		FlexTable table = new FlexTable();
		table.addStyleName(STYLE_ASSET_TABLE);

		/* Build the widgets to add to the table */
		AssetCompareTable compareTable = getAssetCompareTable();
		AssetCompareRecord record = compareTable.getRecord(getDifference());

		/* For each column, add to description table */
		List<Column<?, AssetCompareRecord>> columns = compareTable.getTableColumns();
		for (Column<?, AssetCompareRecord> column : columns) {
			if (column instanceof AssetCompareTableColumn) {
				AssetCompareTableColumn tableColumn = (AssetCompareTableColumn) column;
				if (tableColumn.isShownInFieldDifference()) {
					/* Add the heading */
					LabelWidget label = new LabelWidget();
					label.addStyleName(STYLE_ASSET_TABLE_WIDGET);
					label.addStyleName(STYLE_ASSET_TABLE_HEADING);
					label.setText(column.getDisplayName() + ":");
					addTableWidget(table, label);

					/* Add the value */
					Widget widget = tableColumn.getWidget(record);
					widget.addStyleName(STYLE_ASSET_TABLE_WIDGET);
					widget.addStyleName(STYLE_ASSET_TABLE_VALUE);
					addTableWidget(table, widget);
				}
			}
		}

		return table;
	}

	/*
	 * Get the Asset Compare Table for the current difference record
	 */
	private AssetCompareTable getAssetCompareTable() {
		AssetCompareTable table = null;
		if (difference.isFileAsset()) {
			table = metadataCompareWidget.getReportWidget().getFileCompareWidget().getTable();
		} else {
			table = metadataCompareWidget.getReportWidget().getAssetCompareWidget().getTable();
		}

		return table;
	}

	/*
	 * Add the column at the end of the table
	 */
	private void addTableWidget(FlexTable table, Widget widgetToAdd) {
		int rowCount = table.getRowCount();
		int rowIndex = (rowCount == 0) ? 0 : rowCount - 1;
		int columnIndex = (rowCount == 0) ? 0 : table.getCellCount(rowIndex);
		if (columnIndex >= ASSET_TABLE_CELL_LIMIT) {
			rowIndex++;
			columnIndex = 0;
		}

		table.setWidget(rowIndex, columnIndex, widgetToAdd);
	}

	/*
	 * Get the messages
	 */
	private TitleCompareViewMessages getMessages() {
		return metadataCompareWidget.getMessages();
	}

	// ========================================================================
	// ===================== FOCUSABLE
	// ========================================================================

	@Override
	public int getTabIndex() {
		return container.getTabIndex();
	}

	@Override
	public void setAccessKey(char key) {
		container.setAccessKey(key);

	}

	@Override
	public void setFocus(boolean focused) {
		container.setFocus(focused);
	}

	@Override
	public void setTabIndex(int index) {
		container.setTabIndex(index);
	}
}
