/*
 * Created on Apr 27, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifference;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareRecord;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * The File Compare Widget
 * 
 * @author Vijay Silva
 */
class MetadataCompareWidget extends TitleCompareReportSection {

	/* Properties / Widgets */
	private final Map<UIAssetDifference, AssetMetadataCompareWidget> widgetMap;
	private LabelWidget blankLabel;

	/* Style Names */
	private static final String STYLE_NAME = "content-MetadataCompareWidget";
	private static final String STYLE_BLANK_LABEL = "content-MetadataCompareWidget-blankLabel";
	private static final String STYLE_CONTENTS = "content-MetadataCompareWidget-contents";

	/**
	 * Constructor
	 */
	public MetadataCompareWidget(TitleCompareReportView reportWidget) {
		super(reportWidget);
		widgetMap = new HashMap<UIAssetDifference, AssetMetadataCompareWidget>();
		initialize();
	}

	/*
	 * Initialize the widget
	 */
	private void initialize() {
		/* The style */
		this.addStyleName(STYLE_NAME);

		/* Build the asset compare table to render */
		blankLabel = new LabelWidget();
		blankLabel.addStyleName(STYLE_BLANK_LABEL);
		getContainer().setContent(blankLabel);
	}

	/*
	 * Get the section heading
	 */
	@Override
	protected String getSectionHeading() {
		return getMessages().metadataCompareWidgetHeading();
	}

	/**
	 * Focus on the widget for the given record
	 * 
	 * @param record the record
	 */
	public void showWidgetForRecord(AssetCompareRecord record) {
		if (!getContainer().isOpen()) {
			getContainer().setOpen(true);
		}

		final AssetMetadataCompareWidget widget = widgetMap.get(record.getKey());
		if (widget != null) {
			DeferredCommand.addCommand(new Command() {
				@Override
				public void execute() {
					widget.setFocus(true);
				}
			});
		}
	}

	/**
	 * Refresh the display of this widget
	 */
	public void refresh() {
		/* Clear previous contents */
		getContainer().setContent(blankLabel);
		widgetMap.clear();

		/* If no input, do nothing */
		if (getInput() == null) {
			return;
		}

		/* Collect all records */
		List<AssetCompareRecord> assetRecords = new ArrayList<AssetCompareRecord>();
		assetRecords.addAll(getReportWidget().getAssetCompareWidget().getTable().getRecords());
		assetRecords.addAll(getReportWidget().getFileCompareWidget().getTable().getRecords());

		/* Build the contents */
		VerticalContainer contents = new VerticalContainer();
		contents.addStyleName(STYLE_CONTENTS);
		getContainer().setContent(contents);

		/* For each record, build the field difference widget */
		for (AssetCompareRecord record : assetRecords) {
			/* Build the field difference table for the record if required */
			if (record.getKey().getFieldDifferences().size() > 0) {
				UIAssetDifference key = record.getKey();
				AssetMetadataCompareWidget widget = new AssetMetadataCompareWidget(this, key);
				widgetMap.put(key, widget);
				contents.add(widget);
			}
		}
	}
}
