/*
 * Created on Apr 27, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.report;

import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * A section of the report widget
 * 
 * @author Vijay Silva
 */
abstract class TitleCompareReportSection extends Composite {

	/* Properties / Widgets */
	private SimpleContainer container;
	private DisclosureContainer panel;
	private final TitleCompareReportView reportWidget;

	/* Style Names */
	private static final String STYLE_NAME = "content-TitleCompareReportSection";
	private static final String STYLE_DISCLOSURE = "content-TitleCompareReportSection-disclosure";

	/**
	 * Constructor
	 */
	public TitleCompareReportSection(TitleCompareReportView widget) {
		this.reportWidget = widget;
		this.container = new SimpleContainer();
		initWidget(container);

		initialize();
	}

	/*
	 * Initialize the widget
	 */
	private void initialize() {
		/* The style */
		this.addStyleName(STYLE_NAME);

		/* Build the disclosure panel */
		panel = new RoundedDisclosureContainer(getSectionHeading());
		panel.addStyleName(STYLE_DISCLOSURE);
		panel.setOpen(true);
		container.add(panel);
	}

	/**
	 * @return the reportWidget
	 */
	protected TitleCompareReportView getReportWidget() {
		return reportWidget;
	}

	/**
	 * Get the input for this widget
	 */
	protected TitleCompareViewInput getInput() 
	{
		return reportWidget.getInput();
	}

	/**
	 * Get the messages for this widget
	 */
	protected TitleCompareViewMessages getMessages() {
		return reportWidget.getMessages();
	}

	/**
	 * Get the container used to show the widget contents
	 */
	protected DisclosureContainer getContainer() {
		return this.panel;
	}

	/**
	 * Get the heading to use for the disclosure panel that makes this section
	 * 
	 * @return The section heading
	 */
	protected abstract String getSectionHeading();

	/**
	 * Refresh the display of this widget
	 */
	public abstract void refresh();
}
