/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.report;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * The Title Compare Report Widget
 * 
 * @author Vijay Silva
 */
public class TitleCompareReportView extends ResizableContainer
{
	private ITitleCompareViewController controller;
	private boolean showXML;
	
	private final TitleCompareView parentView;

	private AssetCompareWidget assetWidget;
	private AssetCompareWidget fileWidget;
	private MetadataCompareWidget metadataWidget;
	
	private LabelWidget compareSummaryLabel;
	
	/* Style Names */
	private static final String STYLE_NAME = "content-TitleCompareReportWidget";
	private static final String STYLE_MESSAGE = "content-TitleCompareReportWidget-messageLabel";
	private static final String STYLE_SUMMARY_LABEL = "content-TitleCompareView-summaryLabel";

	/**
	 * Constructor
	 */
	public TitleCompareReportView(TitleCompareView parent, ITitleCompareViewController controller, boolean showXML) 
	{
		super(new VerticalContainer(), null, null);
		
		this.parentView = parent;
		this.controller = controller;
		this.showXML = showXML;

		this.setOffsetHeight(125);
		
		initialize();
	}

	public void setSummaryLabel(String str)
	{
		compareSummaryLabel.setText(str);
	}
	
	/*
	 * Initialize the widgets
	 */
	private void initialize() 
	{
		addStyleName(STYLE_NAME);

		VerticalContainer contents = (VerticalContainer)this.getContent();

		// Header label
		this.compareSummaryLabel = new LabelWidget();
		compareSummaryLabel.addStyleName(STYLE_SUMMARY_LABEL);
		contents.add(compareSummaryLabel);
		
		/* Add the asset difference section */
		assetWidget = new AssetCompareWidget(this);
		contents.add(assetWidget);

		/* Add the file difference section */
		fileWidget = new FileCompareWidget(this);
		contents.add(fileWidget);

		/* Add the metadata difference section */
		metadataWidget = new MetadataCompareWidget(this);
		contents.add(metadataWidget);
		
		// Show differences button
		ButtonWidget showDiffButton = new ButtonWidget("Show Differences");
		showDiffButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		showDiffButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				controller.onShowDifferences();
			}
		});
		this.addButton(null, showDiffButton);

		if(showXML)
		{
			// Show XML button
			ButtonWidget showXmlButton = new ButtonWidget("Show XML");
			showXmlButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
			showXmlButton.addClickHandler(new ClickHandler() 
			{
				@Override
				public void onClick(ClickEvent event) 
				{
					controller.onShowXml();
				}
			});
			this.addButton(null, showXmlButton);
		}
		
		// Cancel button
		ButtonWidget cancelButton = new ButtonWidget();
		cancelButton.setText(getMessages().cancelButtonLabel());
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				controller.onCancel();
			}
		});
		this.addButton(null, cancelButton);
	}

	/*
	 * Get the input from the parent widget
	 */
	TitleCompareViewInput getInput() 
	{
		return parentView.getInput();
	}

	/*
	 * Get the messages for localization
	 */
	TitleCompareViewMessages getMessages() 
	{
		return parentView.getMessages();
	}

	/**
	 * Refresh this view
	 */
	public void refresh() 
	{
		UITitleCompareData data = getInput().compareData;
		
		if(data == null || data.getReport() == null) 
		{
			return;
		}

		assetWidget.refresh();
		fileWidget.refresh();
		metadataWidget.refresh();
	}

	
	/*
	 * Get the asset difference widget
	 */
	AssetCompareWidget getAssetCompareWidget() 
	{
		return this.assetWidget;
	}

	/*
	 * Get the file difference widget
	 */
	AssetCompareWidget getFileCompareWidget() 
	{
		return this.fileWidget;
	}

	/*
	 * Get the metadata difference widget
	 */
	MetadataCompareWidget getMetadataCompareWidget() 
	{
		return this.metadataWidget;
	}
}
