package com.tandbergtv.cms.portal.content.client.title.view.compare.report;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.preview.TitleCompareXmlWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class TitleCompareXmlView extends VerticalPanel 
{
	private static final String STYLE_SUMMARY_LABEL = "content-TitleCompareView-summaryLabel";
	
	private LabelWidget compareSummaryLabel;
	private TitleCompareXmlWidget xmlWidget;
	
	
	public TitleCompareXmlView(TitleCompareView view, ITitleCompareViewController controller, boolean showXML)
	{
		// Header label
		this.compareSummaryLabel = new LabelWidget();
		compareSummaryLabel.addStyleName(STYLE_SUMMARY_LABEL);
		this.add(compareSummaryLabel);
		
		this.xmlWidget = new TitleCompareXmlWidget(view);
		this.add(xmlWidget);
		
		HorizontalPanel buttonPanel = createButtonPanel(controller, showXML);
		this.add(buttonPanel);
	}
	
	private HorizontalPanel createButtonPanel(final ITitleCompareViewController controller, final boolean showXML)
	{
		HorizontalPanel buttonPanel = new HorizontalPanel();
		
		// Show differences button
		ButtonWidget showDiffButton = new ButtonWidget("Show Differences");
		showDiffButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		showDiffButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				controller.onShowDifferences();
			}
		});
		buttonPanel.add(showDiffButton);

		if(showXML)
		{
			// Show XML button
			ButtonWidget showXmlButton = new ButtonWidget("Show XML");
			showXmlButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
			showXmlButton.addClickHandler(new ClickHandler() 
			{
				@Override
				public void onClick(ClickEvent event) 
				{
					controller.onShowXml();
				}
			});
			buttonPanel.add(showXmlButton);
		}
		
		// Cancel button
		ButtonWidget cancelButton = new ButtonWidget();
		cancelButton.setText("Cancel");
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				controller.onCancel();
			}
		});
		buttonPanel.add(cancelButton);
		
		return buttonPanel;
	}
	
	
	public void setSummaryLabel(String str)
	{
		compareSummaryLabel.setText(str);
	}

	
	public void showXmlView(UITitleCompareXmlData preview)
	{
		xmlWidget.showXmlView(preview);
	}
}
